"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingSearchBar = ProfilingSearchBar;
var _public = require("@kbn/unified-search-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../../common");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ProfilingSearchBar({
  kuery,
  rangeFrom,
  rangeTo,
  onQuerySubmit,
  onRefresh,
  onRefreshClick,
  showSubmitButton = true
}) {
  const {
    start: {
      dataViews
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const [dataView, setDataView] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    dataViews.create({
      title: _common.INDEX_EVENTS
    }).then(nextDataView => setDataView(nextDataView));
  }, [dataViews]);
  const searchBarQuery = {
    language: 'kuery',
    query: kuery
  };
  return /*#__PURE__*/_react.default.createElement(_public.SearchBar, {
    onQuerySubmit: ({
      dateRange,
      query
    }) => {
      if (dateRange.from === rangeFrom && dateRange.to === rangeTo && (query === null || query === void 0 ? void 0 : query.query) === kuery) {
        onRefreshClick();
        return;
      }
      onQuerySubmit({
        dateRange,
        query
      });
    },
    showQueryInput: true,
    showDatePicker: true,
    showFilterBar: false,
    showSaveQuery: false,
    submitButtonStyle: !showSubmitButton ? 'iconOnly' : 'auto',
    query: searchBarQuery,
    dateRangeFrom: rangeFrom,
    dateRangeTo: rangeTo,
    indexPatterns: (0, _lodash.compact)([dataView]),
    onRefresh: onRefresh,
    displayStyle: "inPage"
  });
}