"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDataPage = NoDataPage;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_async = require("../hooks/use_async");
var _use_profiling_dependencies = require("./contexts/profiling_dependencies/use_profiling_dependencies");
var _profiling_app_page_template = require("./profiling_app_page_template");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function NoDataPage({
  subTitle
}) {
  var _displayedTab$steps;
  const {
    services: {
      setupDataCollectionInstructions
    },
    start: {
      core
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const {
    data,
    status
  } = (0, _use_async.useAsync)(({
    http
  }) => {
    return setupDataCollectionInstructions({
      http
    });
  }, [setupDataCollectionInstructions]);
  const secretToken = data === null || data === void 0 ? void 0 : data.variables.secretToken;
  const collectionAgentHostPort = data === null || data === void 0 ? void 0 : data.variables.apmServerUrl.replace('https://', '');
  const symbolUrl = data === null || data === void 0 ? void 0 : data.variables.apmServerUrl.replace(/\.apm\./, '.symbols.');
  const hostAgentVersion = 'v3';
  const tabs = [{
    key: 'kubernetes',
    title: _i18n.i18n.translate('xpack.profiling.tabs.kubernetesTitle', {
      defaultMessage: 'Kubernetes'
    }),
    steps: [{
      title: _i18n.i18n.translate('xpack.profiling.tabs.kubernetesRepositoryStep', {
        defaultMessage: 'Configure the Universal Profiling host-agent Helm repository:'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, "helm repo add optimyze https://optimyze.cloud/helm-charts")
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.kubernetesInstallStep', {
        defaultMessage: 'Install host-agent via Helm:'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, `helm install --create-namespace -n=universal-profiling universal-profiling-agent \\
--set "projectID=1,secretToken=${secretToken}" \\
--set "collectionAgentHostPort=${collectionAgentHostPort}" \\
--set "version=${hostAgentVersion}" \\
optimyze/pf-host-agent`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.kubernetesValidationStep', {
        defaultMessage: 'Validate the host-agent pods are running:'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, "kubectl -n universal-profiling get pods")
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.postValidationStep', {
        defaultMessage: 'Use the Helm install output to get host-agent logs and spot potential errors'
      }),
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)
    }]
  }, {
    key: 'docker',
    title: _i18n.i18n.translate('xpack.profiling.tabs.dockerTitle', {
      defaultMessage: 'Docker'
    }),
    steps: [{
      title: _i18n.i18n.translate('xpack.profiling.tabs.dockerRunContainerStep', {
        defaultMessage: 'Run the Universal Profiling container:'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, `docker run --name host-agent --privileged --pid=host -v /etc/machine-id:/etc/machine-id:ro \\
-v /var/run/docker.sock:/var/run/docker.sock -v /sys/kernel/debug:/sys/kernel/debug:ro \\
docker.elastic.co/observability/profiling-agent:${hostAgentVersion} /root/pf-host-agent \\
-project-id=1 -secret-token=${secretToken} \\
-collection-agent=${collectionAgentHostPort}`)
    }]
  }, {
    key: 'binary',
    title: _i18n.i18n.translate('xpack.profiling.tabs.binaryTitle', {
      defaultMessage: 'Binary'
    }),
    steps: [{
      title: _i18n.i18n.translate('xpack.profiling.tabs.binaryDownloadStep', {
        defaultMessage: 'Download the latest binary:'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, `wget -O pf-host-agent.tgz "https://ela.st/pf-host-agent-amd64-${hostAgentVersion}" && tar xzf pf-host-agent.tgz`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.binaryGrantPermissionStep', {
        defaultMessage: 'Grant executable permissions:'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, "chmod +x pf-host-agent/pf-host-agent")
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.binaryRunHostAgentStep', {
        defaultMessage: 'Run the Universal Profiling host-agent (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, `sudo pf-host-agent/pf-host-agent -project-id=1 -secret-token=${secretToken} -collection-agent=${collectionAgentHostPort}`)
    }]
  }, {
    key: 'deb',
    title: _i18n.i18n.translate('xpack.profiling.tabs.debTitle', {
      defaultMessage: 'DEB Package'
    }),
    steps: [{
      title: _i18n.i18n.translate('xpack.profiling.tabs.debDownloadPackageStep', {
        defaultMessage: 'Open the URL below and download the right DEB package for your CPU architecture:'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: `https://ela.st/pf-host-agent-linux-${hostAgentVersion}`
      }, `https://ela.st/pf-host-agent-linux-${hostAgentVersion}`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.debInstallPackageStep', {
        defaultMessage: 'Install the DEB package (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, `sudo dpkg -i pf-host-agent*.deb`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.debEditConfigStep', {
        defaultMessage: 'Edit the configuration (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, `echo -e "project-id 1\nsecret-token ${secretToken}\ncollection-agent ${collectionAgentHostPort}" | sudo tee -a /etc/prodfiler/prodfiler.conf`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.debStartSystemdServiceStep', {
        defaultMessage: 'Start the Universal Profiling systemd service (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, `sudo systemctl enable pf-host-agent && sudo systemctl restart pf-host-agent`)
    }]
  }, {
    key: 'rpm',
    title: _i18n.i18n.translate('xpack.profiling.tabs.rpmTitle', {
      defaultMessage: 'RPM Package'
    }),
    steps: [{
      title: _i18n.i18n.translate('xpack.profiling.tabs.rpmDownloadPackageStep', {
        defaultMessage: 'Open the URL below and download the right RPM package for your CPU architecture:'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: `https://ela.st/pf-host-agent-linux-${hostAgentVersion}`
      }, `https://ela.st/pf-host-agent-linux-${hostAgentVersion}`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.rpmInstallPackageStep', {
        defaultMessage: 'Install the RPM package (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, `sudo rpm -i pf-host-agent*.rpm`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.rpmEditConfigStep', {
        defaultMessage: 'Edit the configuration (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, `echo -e "project-id 1\nsecret-token ${secretToken}\ncollection-agent ${collectionAgentHostPort}" | sudo tee -a /etc/prodfiler/prodfiler.conf`)
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.rpmStartSystemdServiceStep', {
        defaultMessage: 'Start the Universal Profiling systemd service (requires root privileges):'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, `sudo systemctl enable pf-host-agent && sudo systemctl restart pf-host-agent`)
    }]
  }, {
    key: 'symbols',
    title: _i18n.i18n.translate('xpack.profiling.tabs.symbols.title', {
      defaultMessage: 'Upload Symbols'
    }),
    steps: [{
      title: _i18n.i18n.translate('xpack.profiling.tabs.symbols.step1', {
        defaultMessage: 'Download and extract symbtool'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("b", null, "For x86_64:"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, `wget -O symbtool-amd64.tgz "https://ela.st/symbtool-linux-amd64" && tar xzf symbtool-amd64.tgz && cd symbtool-*-linux-x86_64`), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement("b", null, "For ARM64:"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, `wget -O symbtool-arm64.tgz "https://ela.st/symbtool-linux-arm64" && tar xzf symbtool-arm64.tgz && cd symbtool-*-linux-arm64`))
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.symbols.step2', {
        defaultMessage: 'Generate an Elasticsearch token'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: `https://www.elastic.co/guide/en/kibana/master/api-keys.html`
      }, _i18n.i18n.translate('xpack.profiling.tabs.symbols.step2.instructions', {
        defaultMessage: 'Instructions here'
      })))
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.symbols.step3', {
        defaultMessage: 'Upload symbols'
      }),
      content: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, `./symbtool push-symbols executable -u "${symbolUrl}" -t <ES token> -e <my executable>`), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.profiling.tabs.symbols.step3.replace",
        defaultMessage: "Replace {es_token} etc. with the actual values. You can pass {help} to obtain a list of other arguments.",
        values: {
          es_token: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, `<ES token>`),
          help: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "--help")
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.profiling.tabs.symbols.step3.doc-ref",
        defaultMessage: "Documentation for more advanced uses cases is available in {link}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            target: "_blank",
            href: `https://www.elastic.co/guide/en/observability/current/profiling-add-symbols.html`
          }, _i18n.i18n.translate('xpack.profiling.tabs.symbols.step3.doc-ref.link', {
            defaultMessage: 'the corresponding documentation page'
          }))
        }
      })))
    }]
  }, {
    key: 'elasticAgentIntegration',
    title: _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegrarion.title', {
      defaultMessage: 'Elastic Agent Integration'
    }),
    steps: [{
      title: _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegrarion.step1', {
        defaultMessage: 'Copy credentials'
      }),
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegrarion.step1.hint', {
        defaultMessage: "You'll need these credentials to set up Universal Profiling. Please save them in a secure location, as they will be required in the subsequent step."
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegrarion.step1.secretToken', {
        defaultMessage: 'Secret token: {secretToken}',
        values: {
          secretToken
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "s",
        isCopyable: true
      }, _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegrarion.step1.apmServerUrl', {
        defaultMessage: 'APM server url: {apmServerUrl}',
        values: {
          apmServerUrl: collectionAgentHostPort
        }
      })))
    }, {
      title: _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegrarion.step2', {
        defaultMessage: 'Fleet'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: "gear",
        fill: true,
        href: `${core.http.basePath.prepend('/app/integrations/detail/profiler_agent-8.8.0-preview/overview')}`
      }, _i18n.i18n.translate('xpack.profiling.tabs.elasticAgentIntegrarion.step2.button', {
        defaultMessage: 'Manage Universal Profiling agent in Fleet'
      }))
    }]
  }];
  const [selectedTab, setSelectedTab] = (0, _react.useState)(tabs[0].key);
  const displayedTab = tabs.find(tab => tab.key === selectedTab);
  const displayedSteps = (_displayedTab$steps = displayedTab.steps) !== null && _displayedTab$steps !== void 0 ? _displayedTab$steps : [];
  const isLoading = status === _use_async.AsyncStatus.Loading;
  return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
    tabs: [],
    restrictWidth: true,
    hideSearchBar: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoObservability",
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.profiling.noDataPage.pageTitle', {
      defaultMessage: 'Add profiling data'
    })), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)) : null)
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, subTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    grow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    style: {
      padding: '0 24px'
    }
  }, tabs.map(tab => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: tab.key,
      onClick: () => setSelectedTab(tab.key),
      isSelected: tab.key === selectedTab
    }, tab.title);
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    style: {
      padding: '0 24px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: displayedSteps.map(step => {
      return {
        title: step.title,
        children: step.content,
        status: 'incomplete'
      };
    })
  }))))));
}