"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionsView = FunctionsView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_profiling_router = require("../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../hooks/use_profiling_route_path");
var _use_time_range = require("../../hooks/use_time_range");
var _use_time_range_async = require("../../hooks/use_time_range_async");
var _async_component = require("../async_component");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
var _primary_and_comparison_search_bar = require("../primary_and_comparison_search_bar");
var _profiling_app_page_template = require("../profiling_app_page_template");
var _redirect_to = require("../redirect_to");
var _topn_functions = require("../topn_functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FunctionsView({
  children
}) {
  const {
    path,
    query,
    query: {
      rangeFrom,
      rangeTo,
      kuery,
      sortDirection,
      sortField
    }
  } = (0, _use_profiling_params.useProfilingParams)('/functions/*');
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const comparisonTimeRange = (0, _use_time_range.useTimeRange)('comparisonRangeFrom' in query ? {
    rangeFrom: query.comparisonRangeFrom,
    rangeTo: query.comparisonRangeTo,
    optional: true
  } : {
    rangeFrom: undefined,
    rangeTo: undefined,
    optional: true
  });
  const comparisonKuery = 'comparisonKuery' in query ? query.comparisonKuery : '';
  const {
    services: {
      fetchTopNFunctions
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const state = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return fetchTopNFunctions({
      http,
      timeFrom: timeRange.inSeconds.start,
      timeTo: timeRange.inSeconds.end,
      startIndex: 0,
      endIndex: 100000,
      kuery
    });
  }, [timeRange.inSeconds.start, timeRange.inSeconds.end, kuery, fetchTopNFunctions]);
  const comparisonState = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    if (!comparisonTimeRange.inSeconds.start || !comparisonTimeRange.inSeconds.end) {
      return undefined;
    }
    return fetchTopNFunctions({
      http,
      timeFrom: comparisonTimeRange.inSeconds.start,
      timeTo: comparisonTimeRange.inSeconds.end,
      startIndex: 0,
      endIndex: 100000,
      kuery: comparisonKuery
    });
  }, [comparisonTimeRange.inSeconds.start, comparisonTimeRange.inSeconds.end, comparisonKuery, fetchTopNFunctions]);
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const isDifferentialView = routePath === '/functions/differential';
  const tabs = [{
    label: _i18n.i18n.translate('xpack.profiling.functionsView.functionsTabLabel', {
      defaultMessage: 'TopN functions'
    }),
    isSelected: !isDifferentialView,
    href: profilingRouter.link('/functions/topn', {
      query
    })
  }, {
    label: _i18n.i18n.translate('xpack.profiling.functionsView.differentialFunctionsTabLabel', {
      defaultMessage: 'Differential TopN functions'
    }),
    isSelected: isDifferentialView,
    href: profilingRouter.link('/functions/differential', {
      query: {
        ...query,
        comparisonRangeFrom: query.rangeFrom,
        comparisonRangeTo: query.rangeTo,
        comparisonKuery: query.kuery
      }
    })
  }];
  if (routePath === '/functions') {
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
      pathname: "/functions/topn"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
    tabs: tabs,
    hideSearchBar: isDifferentialView
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, isDifferentialView && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_primary_and_comparison_search_bar.PrimaryAndComparisonSearchBar, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({}, state, {
    size: "xl",
    alignTop: true
  }), /*#__PURE__*/_react.default.createElement(_topn_functions.TopNFunctionsTable, {
    topNFunctions: state.data,
    sortDirection: sortDirection,
    sortField: sortField,
    onSortChange: nextSort => {
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          sortField: nextSort.sortField,
          sortDirection: nextSort.sortDirection
        }
      });
    },
    totalSeconds: timeRange.inSeconds.end - timeRange.inSeconds.start,
    isDifferentialView: isDifferentialView
  }))), isDifferentialView && comparisonTimeRange.inSeconds.start && comparisonTimeRange.inSeconds.end ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({}, comparisonState, {
    size: "xl",
    alignTop: true
  }), /*#__PURE__*/_react.default.createElement(_topn_functions.TopNFunctionsTable, {
    sortDirection: sortDirection,
    sortField: sortField,
    onSortChange: nextSort => {
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          sortField: nextSort.sortField,
          sortDirection: nextSort.sortDirection
        }
      });
    },
    topNFunctions: comparisonState.data,
    comparisonTopNFunctions: state.data,
    totalSeconds: comparisonTimeRange.inSeconds.end - comparisonTimeRange.inSeconds.start,
    isDifferentialView: isDifferentialView
  }))) : null))), children));
}