"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlameGraph = FlameGraph;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _get_flamegraph_model = require("../../utils/get_flamegraph_model");
var _flame_graph_legend = require("../flame_graphs_view/flame_graph_legend");
var _frame_information_tooltip = require("../frame_information_window/frame_information_tooltip");
var _flamegraph_tooltip = require("./flamegraph_tooltip");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlameGraph({
  id,
  comparisonMode,
  primaryFlamegraph,
  comparisonFlamegraph,
  baseline,
  comparison,
  showInformationWindow,
  toggleShowInformationWindow
}) {
  var _primaryFlamegraph$To;
  const theme = (0, _eui.useEuiTheme)();
  const columnarData = (0, _react.useMemo)(() => {
    return (0, _get_flamegraph_model.getFlamegraphModel)({
      primaryFlamegraph,
      comparisonFlamegraph,
      colorSuccess: theme.euiTheme.colors.success,
      colorDanger: theme.euiTheme.colors.danger,
      colorNeutral: theme.euiTheme.colors.lightShade,
      comparisonMode,
      baseline,
      comparison
    });
  }, [primaryFlamegraph, comparisonFlamegraph, theme.euiTheme.colors.success, theme.euiTheme.colors.danger, theme.euiTheme.colors.lightShade, comparisonMode, baseline, comparison]);
  const chartTheme = {
    chartMargins: {
      top: 0,
      left: 0,
      bottom: 0,
      right: 0
    },
    chartPaddings: {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    },
    tooltip: {
      maxWidth: 500
    }
  };
  const totalSamples = columnarData.viewModel.value[0];
  const [highlightedVmIndex, setHighlightedVmIndex] = (0, _react.useState)(undefined);
  const selected = primaryFlamegraph && highlightedVmIndex !== undefined ? {
    fileID: primaryFlamegraph.FileID[highlightedVmIndex],
    frameType: primaryFlamegraph.FrameType[highlightedVmIndex],
    exeFileName: primaryFlamegraph.ExeFilename[highlightedVmIndex],
    addressOrLine: primaryFlamegraph.AddressOrLine[highlightedVmIndex],
    functionName: primaryFlamegraph.FunctionName[highlightedVmIndex],
    sourceFileName: primaryFlamegraph.SourceFilename[highlightedVmIndex],
    sourceLine: primaryFlamegraph.SourceLine[highlightedVmIndex],
    countInclusive: primaryFlamegraph.CountInclusive[highlightedVmIndex],
    countExclusive: primaryFlamegraph.CountExclusive[highlightedVmIndex]
  } : undefined;
  (0, _react.useEffect)(() => {
    setHighlightedVmIndex(undefined);
  }, [columnarData.key]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, columnarData.viewModel.label.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    key: columnarData.key
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: chartTheme,
    onElementClick: elements => {
      const selectedElement = elements[0];
      if (Number.isNaN(selectedElement === null || selectedElement === void 0 ? void 0 : selectedElement.vmIndex)) {
        setHighlightedVmIndex(undefined);
      } else {
        setHighlightedVmIndex(selectedElement.vmIndex);
      }
    },
    tooltip: {
      actions: [{
        label: '',
        onSelect: () => {}
      }],
      customTooltip: props => {
        if (!primaryFlamegraph) {
          return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
        }
        const valueIndex = props.values[0].valueAccessor;
        const label = primaryFlamegraph.Label[valueIndex];
        const countInclusive = primaryFlamegraph.CountInclusive[valueIndex];
        const countExclusive = primaryFlamegraph.CountExclusive[valueIndex];
        const totalSeconds = primaryFlamegraph.TotalSeconds;
        const nodeID = primaryFlamegraph.ID[valueIndex];
        const comparisonNode = columnarData.comparisonNodesById[nodeID];
        return /*#__PURE__*/_react.default.createElement(_flamegraph_tooltip.FlameGraphTooltip, {
          isRoot: valueIndex === 0,
          label: label,
          countInclusive: countInclusive,
          countExclusive: countExclusive,
          totalSamples: totalSamples,
          totalSeconds: totalSeconds,
          comparisonCountInclusive: comparisonNode === null || comparisonNode === void 0 ? void 0 : comparisonNode.CountInclusive,
          comparisonCountExclusive: comparisonNode === null || comparisonNode === void 0 ? void 0 : comparisonNode.CountExclusive,
          comparisonTotalSamples: comparisonFlamegraph === null || comparisonFlamegraph === void 0 ? void 0 : comparisonFlamegraph.CountInclusive[0],
          comparisonTotalSeconds: comparisonFlamegraph === null || comparisonFlamegraph === void 0 ? void 0 : comparisonFlamegraph.TotalSeconds,
          baselineScaleFactor: baseline,
          comparisonScaleFactor: comparison,
          onShowMoreClick: () => {
            if (!showInformationWindow) {
              toggleShowInformationWindow();
            }
            setHighlightedVmIndex(valueIndex);
          }
        });
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Flame, {
    id: id,
    columnarData: columnarData.viewModel,
    valueAccessor: d => d.value,
    valueFormatter: value => `${value}`,
    animation: {
      duration: 100
    },
    controlProviderCallback: {}
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_flame_graph_legend.FlameGraphLegend, {
    legendItems: columnarData.legendItems,
    asScale: !!comparisonFlamegraph
  }))), showInformationWindow && /*#__PURE__*/_react.default.createElement(_frame_information_tooltip.FrameInformationTooltip, {
    onClose: toggleShowInformationWindow,
    frame: selected,
    totalSeconds: (_primaryFlamegraph$To = primaryFlamegraph === null || primaryFlamegraph === void 0 ? void 0 : primaryFlamegraph.TotalSeconds) !== null && _primaryFlamegraph$To !== void 0 ? _primaryFlamegraph$To : 0,
    totalSamples: totalSamples
  }));
}