"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlameGraphTooltip = FlameGraphTooltip;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _calculate_impact_estimates = require("../../utils/calculate_impact_estimates");
var _as_cost = require("../../utils/formatters/as_cost");
var _as_percentage = require("../../utils/formatters/as_percentage");
var _as_weight = require("../../utils/formatters/as_weight");
var _cpu_label_with_hint = require("../shared/cpu_label_with_hint");
var _tooltip_row = require("./tooltip_row");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlameGraphTooltip({
  isRoot,
  label,
  countInclusive,
  countExclusive,
  totalSamples,
  totalSeconds,
  baselineScaleFactor,
  comparisonScaleFactor,
  comparisonCountInclusive,
  comparisonCountExclusive,
  comparisonTotalSamples,
  comparisonTotalSeconds,
  onShowMoreClick
}) {
  const theme = (0, _eui.useEuiTheme)();
  const impactEstimates = (0, _calculate_impact_estimates.calculateImpactEstimates)({
    countExclusive,
    countInclusive,
    totalSamples,
    totalSeconds
  });
  const comparisonImpactEstimates = (0, _lodash.isNumber)(comparisonCountExclusive) && (0, _lodash.isNumber)(comparisonCountInclusive) && (0, _lodash.isNumber)(comparisonTotalSamples) && (0, _lodash.isNumber)(comparisonTotalSeconds) ? (0, _calculate_impact_estimates.calculateImpactEstimates)({
    countExclusive: comparisonCountExclusive,
    countInclusive: comparisonCountInclusive,
    totalSamples: comparisonTotalSamples,
    totalSeconds: comparisonTotalSeconds
  }) : undefined;
  return /*#__PURE__*/_react.default.createElement(_charts.TooltipContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, label), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    style: {
      background: theme.euiTheme.border.color
    }
  }), isRoot === false && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_tooltip_row.TooltipRow, {
    label: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
      type: "total",
      labelSize: "xs",
      iconSize: "s",
      labelStyle: {
        fontWeight: 'bold'
      }
    }),
    value: impactEstimates.percentage,
    comparison: comparisonImpactEstimates === null || comparisonImpactEstimates === void 0 ? void 0 : comparisonImpactEstimates.percentage,
    formatValue: _as_percentage.asPercentage,
    showDifference: true,
    formatDifferenceAsPercentage: true
  }), /*#__PURE__*/_react.default.createElement(_tooltip_row.TooltipRow, {
    label: /*#__PURE__*/_react.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
      type: "self",
      labelSize: "xs",
      iconSize: "s",
      labelStyle: {
        fontWeight: 'bold'
      }
    }),
    value: impactEstimates.percentageNoChildren,
    comparison: comparisonImpactEstimates === null || comparisonImpactEstimates === void 0 ? void 0 : comparisonImpactEstimates.percentageNoChildren,
    showDifference: true,
    formatDifferenceAsPercentage: true,
    formatValue: _as_percentage.asPercentage
  })), /*#__PURE__*/_react.default.createElement(_tooltip_row.TooltipRow, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.samplesLabel', {
      defaultMessage: `Samples`
    }),
    value: (0, _lodash.isNumber)(baselineScaleFactor) ? countInclusive * baselineScaleFactor : countInclusive,
    comparison: (0, _lodash.isNumber)(comparisonCountInclusive) && (0, _lodash.isNumber)(comparisonScaleFactor) ? comparisonCountInclusive * comparisonScaleFactor : undefined,
    showDifference: true,
    formatDifferenceAsPercentage: false
  }), /*#__PURE__*/_react.default.createElement(_tooltip_row.TooltipRow, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.annualizedCo2', {
      defaultMessage: `Annualized CO2`
    }),
    value: impactEstimates.annualizedCo2,
    comparison: comparisonImpactEstimates === null || comparisonImpactEstimates === void 0 ? void 0 : comparisonImpactEstimates.annualizedCo2,
    formatValue: _as_weight.asWeight,
    showDifference: true,
    formatDifferenceAsPercentage: false
  }), /*#__PURE__*/_react.default.createElement(_tooltip_row.TooltipRow, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.annualizedDollarCost', {
      defaultMessage: `Annualized dollar cost`
    }),
    value: impactEstimates.annualizedDollarCost,
    comparison: comparisonImpactEstimates === null || comparisonImpactEstimates === void 0 ? void 0 : comparisonImpactEstimates.annualizedDollarCost,
    formatValue: _as_cost.asCost,
    showDifference: true,
    formatDifferenceAsPercentage: false
  }), onShowMoreClick && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    style: {
      background: theme.euiTheme.border.color
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "inspect",
    onClick: onShowMoreClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.showMoreButton', {
    defaultMessage: `Show more information`
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "iInCircle"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.rightClickTip', {
    defaultMessage: `Right-click to pin tooltip`
  })))))))));
}