"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NormalizationMenu = NormalizationMenu;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _flamegraph = require("../../../common/flamegraph");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SCALE_LABEL = _i18n.i18n.translate('xpack.profiling.flameGraphNormalizationMenu.scale', {
  defaultMessage: 'Scale factor'
});
const TIME_LABEL = _i18n.i18n.translate('xpack.profiling.flameGraphNormalizationMenu.time', {
  defaultMessage: 'Time'
});
const NORMALIZE_BY_LABEL = _i18n.i18n.translate('xpack.profiling.flameGraphNormalizationMenu.normalizeBy', {
  defaultMessage: 'Normalize by'
});
function NormalizationMenu(props) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const theme = (0, _eui.useEuiTheme)();
  const baselineScaleFactorInputId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'baselineScaleFactor'
  });
  const comparisonScaleFactorInputId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'comparisonScaleFactor'
  });
  const [mode, setMode] = (0, _react2.useState)(props.mode);
  const [options, setOptions] = (0, _react2.useState)(props.options);
  (0, _react2.useEffect)(() => {
    setMode(props.mode);
    setOptions(props.options);
  }, [props.mode, props.options]);
  const {
    baseline,
    comparison
  } = mode === _flamegraph.FlameGraphNormalizationMode.Time ? {
    comparison: options.comparisonTime,
    baseline: options.baselineTime
  } : {
    comparison: options.comparisonScale,
    baseline: options.baselineScale
  };
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    initialFocus: `#${baselineScaleFactorInputId}`,
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiFormControlLayout, {
      onClick: () => {
        setIsPopoverOpen(popoverOpen => !popoverOpen);
      },
      compressed: true,
      prepend: NORMALIZE_BY_LABEL,
      append: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
        iconType: "arrowDown",
        "aria-label": _i18n.i18n.translate('xpack.profiling.normalizationMenu.menuPopoverButtonAriaLabel', {
          defaultMessage: 'Open normalization menu'
        })
      }),
      css: (0, _react.css)`
            .euiFormLabel {
              max-width: none;
            }
          `
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      style: {
        height: '100%',
        justifyContent: 'center',
        backgroundColor: theme.euiTheme.colors.ghost,
        padding: '0 16px'
      }
    }, props.mode === _flamegraph.FlameGraphNormalizationMode.Scale ? SCALE_LABEL : TIME_LABEL)),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false)
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react2.default.createElement("h4", null, NORMALIZE_BY_LABEL))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("span", null, _i18n.i18n.translate('xpack.profiling.flameGraphNormalizationMenu.normalizeByTimeTooltip', {
      defaultMessage: 'Select Normalize by Scale factor and set your Baseline and Comparison scale factors to compare a set of machines of different sizes. For example, you can compare a deployment of 10% of machines to a deployment of 90% of machines.'
    }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("span", null, _i18n.i18n.translate('xpack.profiling.flameGraphNormalizationMenu.normalizeByScaleTooltip', {
      defaultMessage: 'Select Normalize by Time to compare a set of machines across different time periods. For example, if you compare the last hour to the last 24 hours, the shorter timeframe (1 hour) is multiplied to match the longer timeframe (24 hours).'
    })))),
    position: "right"
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "compressed",
    isFullWidth: true,
    onChange: (id, value) => {
      setMode(id);
    },
    legend: _i18n.i18n.translate('xpack.profiling.flameGraphNormalizationMode.selectModeLegend', {
      defaultMessage: 'Select a normalization mode for the flamegraph'
    }),
    idSelected: mode,
    options: [{
      id: _flamegraph.FlameGraphNormalizationMode.Scale,
      label: SCALE_LABEL
    }, {
      id: _flamegraph.FlameGraphNormalizationMode.Time,
      label: TIME_LABEL
    }]
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react2.default.createElement("h6", null, _i18n.i18n.translate('xpack.profiling.normalizationMenu.baseline', {
    defaultMessage: 'Baseline'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormControlLayout, {
    fullWidth: true,
    prepend: /*#__PURE__*/_react2.default.createElement(_eui.EuiFormLabel, {
      htmlFor: baselineScaleFactorInputId
    }, SCALE_LABEL)
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldNumber, {
    controlOnly: true,
    id: baselineScaleFactorInputId,
    value: baseline,
    onChange: e => {
      if (mode === _flamegraph.FlameGraphNormalizationMode.Scale) {
        setOptions(prevOptions => ({
          ...prevOptions,
          baselineScale: e.target.valueAsNumber
        }));
      }
    },
    disabled: mode === _flamegraph.FlameGraphNormalizationMode.Time
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react2.default.createElement("h6", null, _i18n.i18n.translate('xpack.profiling.normalizationMenu.comparison', {
    defaultMessage: 'Comparison'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormControlLayout, {
    fullWidth: true,
    prepend: /*#__PURE__*/_react2.default.createElement(_eui.EuiFormLabel, {
      htmlFor: comparisonScaleFactorInputId
    }, SCALE_LABEL)
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldNumber, {
    controlOnly: true,
    id: comparisonScaleFactorInputId,
    value: comparison,
    onChange: e => {
      if (mode === _flamegraph.FlameGraphNormalizationMode.Scale) {
        setOptions(prevOptions => ({
          ...prevOptions,
          comparisonScale: e.target.valueAsNumber
        }));
      }
    },
    disabled: mode === _flamegraph.FlameGraphNormalizationMode.Time
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    onClick: () => {
      props.onChange(mode, options);
      setIsPopoverOpen(false);
    },
    fullWidth: true
  }, _i18n.i18n.translate('xpack.profiling.normalizationMenu.applyChanges', {
    defaultMessage: 'Apply changes'
  })));
}