"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlameGraphsView = FlameGraphsView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _flamegraph = require("../../../common/flamegraph");
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_profiling_router = require("../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../hooks/use_profiling_route_path");
var _use_time_range = require("../../hooks/use_time_range");
var _use_time_range_async = require("../../hooks/use_time_range_async");
var _async_component = require("../async_component");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
var _flamegraph2 = require("../flamegraph");
var _profiling_app_page_template = require("../profiling_app_page_template");
var _redirect_to = require("../redirect_to");
var _flame_graph_search_panel = require("./flame_graph_search_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlameGraphsView({
  children
}) {
  const {
    query,
    query: {
      rangeFrom,
      rangeTo,
      kuery
    }
  } = (0, _use_profiling_params.useProfilingParams)('/flamegraphs/*');
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const comparisonTimeRange = (0, _use_time_range.useTimeRange)('comparisonRangeFrom' in query ? {
    rangeFrom: query.comparisonRangeFrom,
    rangeTo: query.comparisonRangeTo,
    optional: true
  } : {
    rangeFrom: undefined,
    rangeTo: undefined,
    optional: true
  });
  const comparisonKuery = 'comparisonKuery' in query ? query.comparisonKuery : '';
  const comparisonMode = 'comparisonMode' in query ? query.comparisonMode : _flamegraph.FlameGraphComparisonMode.Absolute;
  const normalizationMode = (0, _lodash.get)(query, 'normalizationMode', _flamegraph.FlameGraphNormalizationMode.Time);
  const baselineScale = (0, _lodash.get)(query, 'baseline', 1);
  const comparisonScale = (0, _lodash.get)(query, 'comparison', 1);
  const totalSeconds = timeRange.inSeconds.end - timeRange.inSeconds.start;
  const totalComparisonSeconds = (new Date(comparisonTimeRange.end).getTime() - new Date(comparisonTimeRange.start).getTime()) / 1000;
  const baselineTime = 1;
  const comparisonTime = totalSeconds / totalComparisonSeconds;
  const normalizationOptions = {
    baselineScale,
    baselineTime,
    comparisonScale,
    comparisonTime
  };
  const {
    services: {
      fetchElasticFlamechart
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const state = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return Promise.all([fetchElasticFlamechart({
      http,
      timeFrom: timeRange.inSeconds.start,
      timeTo: timeRange.inSeconds.end,
      kuery
    }), comparisonTimeRange.inSeconds.start && comparisonTimeRange.inSeconds.end ? fetchElasticFlamechart({
      http,
      timeFrom: comparisonTimeRange.inSeconds.start,
      timeTo: comparisonTimeRange.inSeconds.end,
      kuery: comparisonKuery
    }) : Promise.resolve(undefined)]).then(([primaryFlamegraph, comparisonFlamegraph]) => {
      return {
        primaryFlamegraph,
        comparisonFlamegraph
      };
    });
  }, [timeRange.inSeconds.start, timeRange.inSeconds.end, kuery, comparisonTimeRange.inSeconds.start, comparisonTimeRange.inSeconds.end, comparisonKuery, fetchElasticFlamechart]);
  const {
    data
  } = state;
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const isDifferentialView = routePath === '/flamegraphs/differential';
  const tabs = [{
    label: _i18n.i18n.translate('xpack.profiling.flameGraphsView.flameGraphTabLabel', {
      defaultMessage: 'Flamegraph'
    }),
    isSelected: !isDifferentialView,
    href: profilingRouter.link('/flamegraphs/flamegraph', {
      query
    })
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphsView.differentialFlameGraphTabLabel', {
      defaultMessage: 'Differential flamegraph'
    }),
    isSelected: isDifferentialView,
    href: profilingRouter.link('/flamegraphs/differential', {
      // @ts-expect-error Code gets too complicated to satisfy TS constraints
      query: {
        ...query,
        comparisonRangeFrom: query.rangeFrom,
        comparisonRangeTo: query.rangeTo,
        comparisonKuery: query.kuery
      }
    })
  }];
  const [showInformationWindow, setShowInformationWindow] = (0, _react.useState)(false);
  function toggleShowInformationWindow() {
    setShowInformationWindow(prev => !prev);
  }
  if (routePath === '/flamegraphs') {
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
      pathname: "/flamegraphs/flamegraph"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
    tabs: tabs,
    hideSearchBar: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_flame_graph_search_panel.FlameGraphSearchPanel, {
    isDifferentialView: isDifferentialView,
    comparisonMode: comparisonMode,
    normalizationMode: normalizationMode,
    normalizationOptions: normalizationOptions
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({}, state, {
    style: {
      height: '100%'
    },
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_flamegraph2.FlameGraph, {
    id: "flamechart",
    primaryFlamegraph: data === null || data === void 0 ? void 0 : data.primaryFlamegraph,
    comparisonFlamegraph: data === null || data === void 0 ? void 0 : data.comparisonFlamegraph,
    comparisonMode: comparisonMode,
    baseline: normalizationMode === _flamegraph.FlameGraphNormalizationMode.Time ? baselineTime : baselineScale,
    comparison: normalizationMode === _flamegraph.FlameGraphNormalizationMode.Time ? comparisonTime : comparisonScale,
    showInformationWindow: showInformationWindow,
    toggleShowInformationWindow: toggleShowInformationWindow
  })), children)));
}