"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlameGraphSearchPanel = FlameGraphSearchPanel;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _flamegraph = require("../../../common/flamegraph");
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_profiling_router = require("../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../hooks/use_profiling_route_path");
var _primary_and_comparison_search_bar = require("../primary_and_comparison_search_bar");
var _primary_profiling_search_bar = require("../profiling_app_page_template/primary_profiling_search_bar");
var _differential_comparison_mode = require("./differential_comparison_mode");
var _normalization_menu = require("./normalization_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlameGraphSearchPanel({
  comparisonMode,
  normalizationMode,
  isDifferentialView,
  normalizationOptions
}) {
  const {
    path,
    query
  } = (0, _use_profiling_params.useProfilingParams)('/flamegraphs/*');
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  function onChangeComparisonMode(nextComparisonMode) {
    if (!('comparisonRangeFrom' in query)) {
      return;
    }
    profilingRouter.push(routePath, {
      path,
      query: {
        ...query,
        ...(nextComparisonMode === _flamegraph.FlameGraphComparisonMode.Absolute ? {
          comparisonMode: _flamegraph.FlameGraphComparisonMode.Absolute,
          normalizationMode
        } : {
          comparisonMode: _flamegraph.FlameGraphComparisonMode.Relative
        })
      }
    });
  }
  function onChangeNormalizationMode(nextNormalizationMode, options) {
    profilingRouter.push(routePath, {
      path: routePath,
      query: nextNormalizationMode === _flamegraph.FlameGraphNormalizationMode.Scale ? {
        ...query,
        baseline: options.baselineScale,
        comparison: options.comparisonScale,
        normalizationMode: nextNormalizationMode
      } : {
        ...query,
        normalizationMode: nextNormalizationMode
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued"
  }, isDifferentialView ? /*#__PURE__*/_react.default.createElement(_primary_and_comparison_search_bar.PrimaryAndComparisonSearchBar, null) : /*#__PURE__*/_react.default.createElement(_primary_profiling_search_bar.PrimaryProfilingSearchBar, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, isDifferentialView && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_differential_comparison_mode.DifferentialComparisonMode, {
    comparisonMode: comparisonMode,
    onChange: onChangeComparisonMode
  }), comparisonMode === _flamegraph.FlameGraphComparisonMode.Absolute && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_normalization_menu.NormalizationMenu, {
    onChange: onChangeNormalizationMode,
    mode: normalizationMode,
    options: normalizationOptions
  })))))));
}