"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DifferentialComparisonMode = DifferentialComparisonMode;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _flamegraph = require("../../../common/flamegraph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DifferentialComparisonMode({
  comparisonMode,
  onChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.profiling.flameGraphsView.differentialFlameGraphComparisonModeTitle', {
    defaultMessage: 'Format'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.profiling.flameGraphsView.differentialFlameGraphComparisonModeLegend', {
      defaultMessage: 'This switch allows you to switch between an absolute and relative comparison between both graphs'
    }),
    type: "single",
    buttonSize: "s",
    idSelected: comparisonMode,
    onChange: nextComparisonMode => {
      onChange(nextComparisonMode);
    },
    options: [{
      id: _flamegraph.FlameGraphComparisonMode.Absolute,
      label: _i18n.i18n.translate('xpack.profiling.flameGraphsView.differentialFlameGraphComparisonModeAbsoluteButtonLabel', {
        defaultMessage: 'Abs'
      })
    }, {
      id: _flamegraph.FlameGraphComparisonMode.Relative,
      label: _i18n.i18n.translate('xpack.profiling.flameGraphsView.differentialFlameGraphComparisonModeRelativeButtonLabel', {
        defaultMessage: 'Rel'
      })
    }]
  }))));
}