"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RouteBreadcrumbsContext = void 0;
exports.RouteBreadcrumbsContextProvider = RouteBreadcrumbsContextProvider;
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RouteBreadcrumbsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
exports.RouteBreadcrumbsContext = RouteBreadcrumbsContext;
function RouteBreadcrumbsContextProvider({
  children
}) {
  const [, forceUpdate] = (0, _react.useState)({});
  const breadcrumbs = (0, _react.useMemo)(() => {
    return new Map();
  }, []);
  const matches = (0, _typedReactRouterConfig.useMatchRoutes)();
  const api = (0, _react.useMemo)(() => ({
    set(route, breadcrumb) {
      if (!(0, _lodash.isEqual)(breadcrumbs.get(route), breadcrumb)) {
        breadcrumbs.set(route, breadcrumb);
        forceUpdate({});
      }
    },
    unset(route) {
      if (breadcrumbs.has(route)) {
        breadcrumbs.delete(route);
        forceUpdate({});
      }
    },
    getBreadcrumbs(currentMatches) {
      return (0, _lodash.compact)(currentMatches.flatMap(match => {
        const breadcrumb = breadcrumbs.get(match.route);
        return breadcrumb;
      }));
    }
  }), [breadcrumbs]);
  const formattedBreadcrumbs = api.getBreadcrumbs(matches).map((breadcrumb, index, array) => {
    return {
      text: breadcrumb.title,
      ...(index === array.length - 1 ? {} : {
        href: breadcrumb.href
      })
    };
  });
  (0, _public.useBreadcrumbs)(formattedBreadcrumbs);
  return /*#__PURE__*/_react.default.createElement(RouteBreadcrumbsContext.Provider, {
    value: api
  }, children);
}