"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CheckSetup = CheckSetup;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_async = require("../hooks/use_async");
var _use_auto_aborted_http_client = require("../hooks/use_auto_aborted_http_client");
var _use_license_context = require("./contexts/license/use_license_context");
var _use_profiling_dependencies = require("./contexts/profiling_dependencies/use_profiling_dependencies");
var _no_data_page = require("./no_data_page");
var _profiling_app_page_template = require("./profiling_app_page_template");
var _license_prompt = require("./shared/license_prompt");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CheckSetup({
  children
}) {
  const {
    start: {
      core
    },
    services: {
      fetchHasSetup,
      postSetupResources
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const license = (0, _use_license_context.useLicenseContext)();
  const {
    docLinks,
    notifications
  } = core;
  const [postSetupLoading, setPostSetupLoading] = (0, _react.useState)(false);
  const {
    status,
    data,
    error,
    refresh
  } = (0, _use_async.useAsync)(({
    http
  }) => {
    return fetchHasSetup({
      http
    });
  }, [fetchHasSetup]);
  const http = (0, _use_auto_aborted_http_client.useAutoAbortedHttpClient)([]);
  if (!(license !== null && license !== void 0 && license.hasAtLeast('enterprise'))) {
    return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
      hideSearchBar: true,
      tabs: []
    }, /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, null));
  }
  const displaySetupScreen = status === _use_async.AsyncStatus.Settled && (data === null || data === void 0 ? void 0 : data.has_setup) !== true || !!error;
  const displayNoDataScreen = status === _use_async.AsyncStatus.Settled && (data === null || data === void 0 ? void 0 : data.has_setup) === true && (data === null || data === void 0 ? void 0 : data.has_data) === false;
  const displayUi = (data === null || data === void 0 ? void 0 : data.has_data) === true;
  const displayLoadingScreen = status !== _use_async.AsyncStatus.Settled;
  if (displayLoadingScreen) {
    return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
      hideSearchBar: true,
      tabs: []
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.profiling.noDataConfig.loading.loaderText', {
      defaultMessage: 'Loading data sources'
    })))));
  }
  if (displayUi) {
    return children;
  }
  if (displayNoDataScreen) {
    return /*#__PURE__*/_react.default.createElement(_no_data_page.NoDataPage, {
      subTitle: _i18n.i18n.translate('xpack.profiling.noDataPage.introduction', {
        defaultMessage: `You're almost there! Follow the instructions below to add data.`
      })
    });
  }
  if (displaySetupScreen) {
    return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
      tabs: [],
      noDataConfig: {
        docsLink: `${docLinks.ELASTIC_WEBSITE_URL}/guide/en/observability/${docLinks.DOC_LINK_VERSION}/profiling-get-started.html`,
        logo: 'logoObservability',
        pageTitle: _i18n.i18n.translate('xpack.profiling.noDataConfig.pageTitle', {
          defaultMessage: 'Universal Profiling (now in Beta)'
        }),
        action: {
          elasticAgent: {
            description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
              gutterSize: "s"
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.profiling.noDataConfig.action.title', {
              defaultMessage: `Universal Profiling provides fleet-wide, whole-system, continuous profiling with zero instrumentation.
              Understand what lines of code are consuming compute resources, at all times, and across your entire infrastructure.`
            })), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
              size: "s",
              color: "warning",
              title: _i18n.i18n.translate('xpack.profiling.noDataConfig.action.permissionsWarning', {
                defaultMessage: 'To setup Universal Profiling, you must be logged in as a superuser.'
              })
            }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
              size: 'xs'
            }, /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.profiling.noDataConfig.action.dataRetention",
              defaultMessage: "Normal data storage costs apply for profiling data stored in Elasticsearch. Learn more about {dataRetentionLink}.",
              values: {
                dataRetentionLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
                  href: `${docLinks.ELASTIC_WEBSITE_URL}/guide/en/elasticsearch/reference/${docLinks.DOC_LINK_VERSION}/set-up-lifecycle-policy.html`,
                  target: "_blank"
                }, _i18n.i18n.translate('xpack.profiling.noDataConfig.action.dataRetention.link', {
                  defaultMessage: 'controlling data retention'
                }))
              }
            })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.profiling.noDataConfig.action.legalBetaTerms', {
              defaultMessage: `By using this feature, you acknowledge that you have read and agree to `
            }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              target: "_blank",
              href: `https://www.elastic.co/agreements/beta-release-terms`
            }, _i18n.i18n.translate('xpack.profiling.noDataConfig.betaTerms.linkLabel', {
              defaultMessage: 'Elastic Beta Release Terms'
            }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
              size: 'xs'
            })),
            onClick: event => {
              event.preventDefault();
            },
            button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
              disabled: postSetupLoading,
              onClick: event => {
                event.preventDefault();
                setPostSetupLoading(true);
                postSetupResources({
                  http
                }).then(() => refresh()).catch(err => {
                  var _ref, _err$body$message, _err$body;
                  const message = (_ref = (_err$body$message = err === null || err === void 0 ? void 0 : (_err$body = err.body) === null || _err$body === void 0 ? void 0 : _err$body.message) !== null && _err$body$message !== void 0 ? _err$body$message : err.message) !== null && _ref !== void 0 ? _ref : String(err);
                  notifications.toasts.addError(err, {
                    title: _i18n.i18n.translate('xpack.profiling.checkSetup.setupFailureToastTitle', {
                      defaultMessage: 'Failed to complete setup'
                    }),
                    toastMessage: message
                  });
                }).finally(() => {
                  setPostSetupLoading(false);
                });
              },
              fill: true,
              isLoading: postSetupLoading
            }, !postSetupLoading ? _i18n.i18n.translate('xpack.profiling.noDataConfig.action.buttonLabel', {
              defaultMessage: 'Set up Universal Profiling'
            }) : _i18n.i18n.translate('xpack.profiling.noDataConfig.action.buttonLoadingLabel', {
              defaultMessage: 'Setting up Universal Profiling...'
            }))
          }
        },
        solution: _i18n.i18n.translate('xpack.profiling.noDataConfig.solutionName', {
          defaultMessage: 'Universal Profiling'
        })
      },
      hideSearchBar: true
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null));
  }
  throw new Error('Invalid state');
}