"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartGrid = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _subchart = require("./subchart");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartGrid = ({
  limit,
  charts,
  showFrames
}) => {
  var _charts$length;
  const maximum = Math.min(limit, (_charts$length = charts.length) !== null && _charts$length !== void 0 ? _charts$length : 0);
  const ncharts = Math.min(maximum, charts.length);
  const [selectedSubchart, setSelectedSubchart] = (0, _react.useState)(undefined);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h1", null, "Top ", charts.length)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "m"
  }, (0, _lodash.take)(charts, ncharts).map((subchart, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: i
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_subchart.SubChart, {
    index: subchart.Index,
    color: subchart.Color,
    category: subchart.Category,
    label: subchart.Label,
    percentage: subchart.Percentage,
    metadata: subchart.Metadata,
    height: 200,
    data: subchart.Series,
    sample: null,
    showAxes: true,
    onShowMoreClick: () => {
      setSelectedSubchart(subchart);
    },
    showFrames: showFrames,
    padTitle: true
  }))))), selectedSubchart && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => {
      setSelectedSubchart(undefined);
    }
  }, /*#__PURE__*/_react.default.createElement(_subchart.SubChart, {
    style: {
      overflow: 'auto'
    },
    index: selectedSubchart.Index,
    color: selectedSubchart.Color,
    category: selectedSubchart.Category,
    label: selectedSubchart.Label,
    percentage: selectedSubchart.Percentage,
    metadata: selectedSubchart.Metadata,
    height: 200,
    data: selectedSubchart.Series,
    sample: null,
    showAxes: true,
    onShowMoreClick: null,
    showFrames: showFrames,
    padTitle: true
  })));
};
exports.ChartGrid = ChartGrid;