"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PluginServiceProvidersMediator = void 0;
var _dependency_manager = require("./dependency_manager");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class PluginServiceProvidersMediator {
  constructor(providers) {
    this.providers = providers;
  }
  start(params) {
    this.getOrderedDependencies().forEach(service => {
      this.providers[service].start(params, this.getServiceDependencies(service));
    });
  }
  stop() {
    this.getOrderedDependencies().forEach(service => this.providers[service].stop());
  }
  getOrderedDependencies() {
    const dependenciesGraph = this.getGraphOfDependencies();
    return _dependency_manager.DependencyManager.orderDependencies(dependenciesGraph);
  }
  getGraphOfDependencies() {
    return this.getProvidersNames().reduce((graph, vertex) => {
      var _this$providers$verte;
      return {
        ...graph,
        [vertex]: (_this$providers$verte = this.providers[vertex].requiredServices) !== null && _this$providers$verte !== void 0 ? _this$providers$verte : []
      };
    }, {});
  }
  getProvidersNames() {
    return Object.keys(this.providers);
  }
  getServiceDependencies(service) {
    var _this$providers$servi;
    const requiredServices = (_this$providers$servi = this.providers[service].requiredServices) !== null && _this$providers$servi !== void 0 ? _this$providers$servi : [];
    return this.getServicesByDeps(requiredServices);
  }
  getServicesByDeps(deps) {
    return deps.reduce((services, dependency) => ({
      ...services,
      [dependency]: this.providers[dependency].getService()
    }), {});
  }
}
exports.PluginServiceProvidersMediator = PluginServiceProvidersMediator;