"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "FloatingActions", {
  enumerable: true,
  get: function () {
    return _components.FloatingActions;
  }
});
Object.defineProperty(exports, "LazyDashboardPicker", {
  enumerable: true,
  get: function () {
    return _components.LazyDashboardPicker;
  }
});
Object.defineProperty(exports, "LazyDataViewPicker", {
  enumerable: true,
  get: function () {
    return _components.LazyDataViewPicker;
  }
});
Object.defineProperty(exports, "LazyExpressionInput", {
  enumerable: true,
  get: function () {
    return _components.LazyExpressionInput;
  }
});
Object.defineProperty(exports, "LazyFieldPicker", {
  enumerable: true,
  get: function () {
    return _components.LazyFieldPicker;
  }
});
Object.defineProperty(exports, "LazyLabsBeakerButton", {
  enumerable: true,
  get: function () {
    return _components.LazyLabsBeakerButton;
  }
});
Object.defineProperty(exports, "LazyLabsFlyout", {
  enumerable: true,
  get: function () {
    return _components.LazyLabsFlyout;
  }
});
Object.defineProperty(exports, "LazySavedObjectSaveModalDashboard", {
  enumerable: true,
  get: function () {
    return _components.LazySavedObjectSaveModalDashboard;
  }
});
Object.defineProperty(exports, "PluginServiceProvider", {
  enumerable: true,
  get: function () {
    return _create.PluginServiceProvider;
  }
});
Object.defineProperty(exports, "PluginServiceRegistry", {
  enumerable: true,
  get: function () {
    return _create.PluginServiceRegistry;
  }
});
Object.defineProperty(exports, "PluginServices", {
  enumerable: true,
  get: function () {
    return _create.PluginServices;
  }
});
Object.defineProperty(exports, "cleanFiltersForSerialize", {
  enumerable: true,
  get: function () {
    return _redux_tools.cleanFiltersForSerialize;
  }
});
exports.getContextProvider = void 0;
Object.defineProperty(exports, "lazyLoadReduxToolsPackage", {
  enumerable: true,
  get: function () {
    return _redux_tools.lazyLoadReduxToolsPackage;
  }
});
exports.plugin = plugin;
exports.useLabs = exports.registerExpressionsLanguage = void 0;
Object.defineProperty(exports, "withSuspense", {
  enumerable: true,
  get: function () {
    return _components.withSuspense;
  }
});
var _plugin = require("./plugin");
var _services = require("./services");
var _create = require("./services/create");
var _components = require("./components");
var _redux_tools = require("./redux_tools");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/**
 * Register a set of Expression Functions with the Presentation Utility ExpressionInput.  This allows
 * the Monaco Editor to understand the functions and their arguments.
 *
 * This function is async in order to move the logic to an async chunk.
 *
 * @param expressionFunctions A set of Expression Functions to use in the ExpressionInput.
 */
const registerExpressionsLanguage = async expressionFunctions => {
  const languages = await Promise.resolve().then(() => _interopRequireWildcard(require('./components/expression_input/language')));
  return languages.registerExpressionsLanguage(expressionFunctions);
};
exports.registerExpressionsLanguage = registerExpressionsLanguage;
function plugin() {
  return new _plugin.PresentationUtilPlugin();
}
const useLabs = () => (() => _services.pluginServices.getHooks().labs.useService())();
exports.useLabs = useLabs;
const getContextProvider = () => _services.pluginServices.getContextProvider();
exports.getContextProvider = getContextProvider;