"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-objects-plugin/public");
var _services = require("../services");
var _saved_object_save_modal_dashboard_selector = require("./saved_object_save_modal_dashboard_selector");
require("./saved_object_save_modal_dashboard.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function SavedObjectSaveModalDashboard(props) {
  const {
    documentInfo,
    tagOptions,
    objectType,
    onClose,
    canSaveByReference
  } = props;
  const {
    id: documentId
  } = documentInfo;
  const initialCopyOnSave = !Boolean(documentId);
  const {
    capabilities
  } = _services.pluginServices.getHooks();
  const {
    canAccessDashboards,
    canCreateNewDashboards
  } = capabilities.useService();

  // Disable the dashboard options if the user can't access dashboards or if they're read-only
  const disableDashboardOptions = !canAccessDashboards() || !canCreateNewDashboards();
  const [dashboardOption, setDashboardOption] = (0, _react.useState)(documentId || disableDashboardOptions ? null : 'existing');
  const [isAddToLibrarySelected, setAddToLibrary] = (0, _react.useState)(canSaveByReference && (!initialCopyOnSave || disableDashboardOptions));
  const [selectedDashboard, setSelectedDashboard] = (0, _react.useState)(null);
  const [copyOnSave, setCopyOnSave] = (0, _react.useState)(initialCopyOnSave);
  const rightOptions = !disableDashboardOptions ? () => /*#__PURE__*/_react.default.createElement(_saved_object_save_modal_dashboard_selector.SaveModalDashboardSelector, {
    onSelectDashboard: dash => {
      setSelectedDashboard(dash);
    },
    onChange: option => {
      setDashboardOption(option);
    },
    canSaveByReference: canSaveByReference,
    copyOnSave,
    documentId,
    dashboardOption,
    setAddToLibrary,
    isAddToLibrarySelected
  }) : null;
  const onCopyOnSaveChange = newCopyOnSave => {
    if (canSaveByReference) {
      setAddToLibrary(true);
    }
    setDashboardOption(null);
    setCopyOnSave(newCopyOnSave);
  };
  const onModalSave = onSaveProps => {
    let dashboardId = null;

    // Don't save with a dashboard ID if we're
    // just updating an existing visualization
    if (!(!onSaveProps.newCopyOnSave && documentId)) {
      if (dashboardOption === 'existing') {
        dashboardId = (selectedDashboard === null || selectedDashboard === void 0 ? void 0 : selectedDashboard.id) || null;
      } else {
        dashboardId = dashboardOption;
      }
    }
    props.onSave({
      ...onSaveProps,
      dashboardId,
      addToLibrary: isAddToLibrarySelected
    });
  };
  const saveLibraryLabel = !copyOnSave && documentId ? _i18n.i18n.translate('presentationUtil.saveModalDashboard.saveLabel', {
    defaultMessage: 'Save'
  }) : _i18n.i18n.translate('presentationUtil.saveModalDashboard.saveToLibraryLabel', {
    defaultMessage: 'Save and add to library'
  });
  const saveDashboardLabel = _i18n.i18n.translate('presentationUtil.saveModalDashboard.saveAndGoToDashboardLabel', {
    defaultMessage: 'Save and go to Dashboard'
  });
  const confirmButtonLabel = dashboardOption === null ? saveLibraryLabel : saveDashboardLabel;
  const isValid = !(dashboardOption === 'existing' && selectedDashboard === null);
  return /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModal, {
    onSave: onModalSave,
    title: documentInfo.title,
    showCopyOnSave: documentId ? true : false,
    options: isAddToLibrarySelected ? tagOptions : undefined // Show tags when not adding to dashboard
    ,
    description: documentInfo.description,
    showDescription: true,
    confirmButtonLabel,
    initialCopyOnSave,
    isValid,
    objectType,
    onClose,
    onCopyOnSaveChange,
    rightOptions
  });
}

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
var _default = SavedObjectSaveModalDashboard;
exports.default = _default;
module.exports = exports.default;