"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LabsBeakerButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _services = require("../../services");
var _labs_flyout = require("./labs_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LabsBeakerButton = ({
  solutions,
  ...props
}) => {
  const {
    labs: labsService
  } = _services.pluginServices.getHooks();
  const {
    getProjects
  } = labsService.useService();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const projects = getProjects();
  const [overrideCount, onEnabledCountChange] = (0, _react.useState)(Object.values(projects).filter(project => project.status.isOverride).length);
  const onButtonClick = () => setIsOpen(open => !open);
  const onClose = () => setIsOpen(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, props, {
    onClick: onButtonClick,
    minWidth: 0
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "beaker"
  }), overrideCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued",
    style: {
      marginLeft: 2
    }
  }, overrideCount) : null), isOpen ? /*#__PURE__*/_react.default.createElement(_labs_flyout.LabsFlyout, {
    onClose,
    solutions,
    onEnabledCountChange
  }) : null);
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.LabsBeakerButton = LabsBeakerButton;
var _default = LabsBeakerButton;
exports.default = _default;