"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnvironmentSwitch = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _services = require("../../services");
var _i18n = require("../../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const {
  Switch: strings
} = _i18n.LabsStrings.Components;
const switchText = {
  kibana: strings.getKibanaSwitchText(),
  browser: strings.getBrowserSwitchText(),
  session: strings.getSessionSwitchText()
};
const EnvironmentSwitch = ({
  env,
  isChecked,
  onChange,
  name
}) => {
  const {
    capabilities
  } = _services.pluginServices.getHooks();
  const canSet = env === 'kibana' ? capabilities.useService().canSetAdvancedSettings() : true;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      marginBottom: '.25rem'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: !canSet,
    checked: isChecked,
    style: {
      marginTop: 1
    },
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, name, " - ")), switchText[env].name),
    onChange: e => onChange(e.target.checked),
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      textAlign: 'right'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: switchText[env].help,
    position: "left"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }));
};
exports.EnvironmentSwitch = EnvironmentSwitch;