"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  withSuspense: true,
  LazyLabsBeakerButton: true,
  LazyLabsFlyout: true,
  LazyDashboardPicker: true,
  LazySavedObjectSaveModalDashboard: true,
  LazyDataViewPicker: true,
  LazyFieldPicker: true,
  LazyExpressionInput: true,
  FloatingActions: true
};
Object.defineProperty(exports, "FloatingActions", {
  enumerable: true,
  get: function () {
    return _floating_actions.FloatingActions;
  }
});
exports.withSuspense = exports.LazySavedObjectSaveModalDashboard = exports.LazyLabsFlyout = exports.LazyLabsBeakerButton = exports.LazyFieldPicker = exports.LazyExpressionInput = exports.LazyDataViewPicker = exports.LazyDashboardPicker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _floating_actions = require("./floating_actions/floating_actions");
var _types = require("./types");
Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/**
 * A HOC which supplies React.Suspense with a fallback component, and a `EuiErrorBoundary` to contain errors.
 * @param Component A component deferred by `React.lazy`
 * @param fallback A fallback component to render while things load; default is `EuiLoadingSpinner`
 */
const withSuspense = (Component, fallback = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)) => /*#__PURE__*/_react.default.forwardRef((props, ref) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: fallback
  }, /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
    ref: ref
  }))));
});
exports.withSuspense = withSuspense;
const LazyLabsBeakerButton = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./labs/labs_beaker_button'))));
exports.LazyLabsBeakerButton = LazyLabsBeakerButton;
const LazyLabsFlyout = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./labs/labs_flyout'))));
exports.LazyLabsFlyout = LazyLabsFlyout;
const LazyDashboardPicker = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./dashboard_picker'))));
exports.LazyDashboardPicker = LazyDashboardPicker;
const LazySavedObjectSaveModalDashboard = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./saved_object_save_modal_dashboard'))));
exports.LazySavedObjectSaveModalDashboard = LazySavedObjectSaveModalDashboard;
const LazyDataViewPicker = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./data_view_picker/data_view_picker'))));
exports.LazyDataViewPicker = LazyDataViewPicker;
const LazyFieldPicker = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./field_picker/field_picker'))));
exports.LazyFieldPicker = LazyFieldPicker;
/**
 * A lazily-loaded ExpressionInput component.
 */
const LazyExpressionInput = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./expression_input'))));
exports.LazyExpressionInput = LazyExpressionInput;