"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SECURITY_APP_NAME = exports.AddToTimelineButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _kibana = require("../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimelineComponent = /*#__PURE__*/_react.default.memo(props => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({}, props, {
  size: "xs"
})));
TimelineComponent.displayName = 'TimelineComponent';
const SECURITY_APP_NAME = 'Security';
exports.SECURITY_APP_NAME = SECURITY_APP_NAME;
const AddToTimelineButton = props => {
  const {
    timelines,
    appName
  } = (0, _kibana.useKibana)().services;
  const {
    field,
    value,
    isIcon,
    iconProps
  } = props;
  const queryIds = (0, _lodash.isArray)(value) ? value : [value];
  const TimelineIconComponent = (0, _react.useCallback)(timelineComponentProps => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    iconType: "timelines"
  }, timelineComponentProps, {
    size: "xs"
  }, iconProps)), [iconProps]);
  if (!timelines || appName !== SECURITY_APP_NAME || !queryIds.length) {
    return null;
  }
  const {
    getAddToTimelineButton
  } = timelines.getHoverActions();
  const providers = queryIds.map(queryId => ({
    and: [],
    enabled: true,
    excluded: false,
    id: queryId,
    kqlQuery: '',
    name: queryId,
    queryMatch: {
      field,
      value: queryId,
      operator: ':'
    }
  }));
  return getAddToTimelineButton({
    dataProvider: providers,
    field: queryIds[0],
    ownFocus: false,
    ...(isIcon ? {
      showTooltip: true,
      Component: TimelineIconComponent
    } : {
      Component: TimelineComponent
    })
  });
};
exports.AddToTimelineButton = AddToTimelineButton;