"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../common/lib/kibana");
var _query_client = require("../query_client");
var _shared_imports = require("../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ServicesWrapperComponent = ({
  services,
  children
}) => /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaThemeProvider, {
  theme$: services.theme.theme$
}, /*#__PURE__*/_react.default.createElement(_kibana.KibanaContextProvider, {
  services: services
}, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
  client: _query_client.queryClient
}, children))));
const ServicesWrapper = /*#__PURE__*/_react.default.memo(ServicesWrapperComponent);

// eslint-disable-next-line import/no-default-export
exports.default = ServicesWrapper;
module.exports = exports.default;