"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _lodash = require("lodash");
var _use_pack = require("../../packs/use_pack");
var _query_pack_selectable = require("../../live_queries/form/query_pack_selectable");
var _kibana = require("../../common/lib/kibana");
var _live_query_query_field = require("../../live_queries/form/live_query_query_field");
var _pack_field_wrapper = require("./pack_field_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OsqueryResponseActionParamsFormComponent = ({
  defaultValues,
  onError,
  onChange
}) => {
  const hooksForm = (0, _reactHookForm.useForm)({
    mode: 'all',
    defaultValues: defaultValues ? {
      ...(0, _lodash.omit)(defaultValues, ['ecsMapping', 'packId']),
      ecs_mapping: defaultValues.ecsMapping,
      packId: defaultValues.packId ? [defaultValues.packId] : [],
      queryType: defaultValues.packId ? 'pack' : 'query'
    } : {
      ecs_mapping: {},
      queryType: 'query'
    }
  });
  const {
    watch,
    register,
    formState,
    control
  } = hooksForm;
  const [packId, queryType, queries] = watch(['packId', 'queryType', 'queries']);
  const {
    data: packData
  } = (0, _use_pack.usePack)({
    packId: packId === null || packId === void 0 ? void 0 : packId[0],
    skip: !(packId !== null && packId !== void 0 && packId[0])
  });
  const {
    replace
  } = (0, _reactHookForm.useFieldArray)({
    name: 'queries',
    control
  });
  (0, _react.useEffect)(() => {
    if (packData !== null && packData !== void 0 && packData.queries) {
      const queriesArray = (0, _lodash.map)(packData === null || packData === void 0 ? void 0 : packData.queries, (query, queryId) => ({
        ...query,
        id: queryId
      }));
      replace(queriesArray);
    }
  }, [packData, replace]);
  (0, _react.useEffect)(() => {
    onError(formState.errors);
  }, [onError, formState]);
  (0, _react.useEffect)(() => {
    register('savedQueryId');
  }, [register]);
  (0, _react.useEffect)(() => {
    const subscription = watch(formData => {
      var _formData$packId;
      onChange(
      // @ts-expect-error update types
      formData.queryType === 'pack' ? {
        packId: formData !== null && formData !== void 0 && (_formData$packId = formData.packId) !== null && _formData$packId !== void 0 && _formData$packId.length ? formData === null || formData === void 0 ? void 0 : formData.packId[0] : undefined,
        queries: formData.queries
      } : {
        savedQueryId: formData.savedQueryId,
        query: formData.query,
        ecsMapping: formData.ecs_mapping
      });
    });
    return () => subscription.unsubscribe();
  }, [onChange, packData, watch]);
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const canRunPacks = (0, _react.useMemo)(() => !!((permissions.runSavedQueries || permissions.writeLiveQueries) && permissions.readPacks), [permissions]);
  const canRunSingleQuery = (0, _react.useMemo)(() => !!(permissions.writeLiveQueries || permissions.runSavedQueries && permissions.readSavedQueries), [permissions]);
  const queryDetails = (0, _react.useMemo)(() => ({
    queries,
    agents: []
  }), [queries]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, hooksForm, /*#__PURE__*/_react.default.createElement(_query_pack_selectable.QueryPackSelectable, {
    canRunPacks: canRunPacks,
    canRunSingleQuery: canRunSingleQuery
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), queryType === 'query' && /*#__PURE__*/_react.default.createElement(_live_query_query_field.LiveQueryQueryField, null), queryType === 'pack' && /*#__PURE__*/_react.default.createElement(_pack_field_wrapper.PackFieldWrapper, {
    liveQueryDetails: queries && !packData ? queryDetails : undefined
  })));
};
const OsqueryResponseActionParamsForm = /*#__PURE__*/_react.default.memo(OsqueryResponseActionParamsFormComponent);

// Export as default in order to support lazy loading
// eslint-disable-next-line import/no-default-export
exports.default = OsqueryResponseActionParamsForm;
module.exports = exports.default;