"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsOsqueryAvailableSimple = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _kibana = require("../../common/lib/kibana");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsOsqueryAvailableSimple = ({
  agentId
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const [isAvailable, setIsAvailable] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    (async () => {
      try {
        const {
          item: agentInfo
        } = await http.get(`/internal/osquery/fleet_wrapper/agents/${agentId}`);
        const {
          item: packageInfo
        } = await http.get(`/internal/osquery/fleet_wrapper/agent_policies/${agentInfo.policy_id}`);
        const osqueryPackageInstalled = (0, _lodash.find)(packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.package_policies, ['package.name', _common.OSQUERY_INTEGRATION_NAME]);
        setIsAvailable(osqueryPackageInstalled.enabled);
      } catch (err) {
        return;
      }
    })();
  }, [agentId, http]);
  return isAvailable;
};
exports.useIsOsqueryAvailableSimple = useIsOsqueryAvailableSimple;