"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLazyExternalContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _osquery_icon = require("../../components/osquery_icon");
var _kibana = require("../../common/lib/kibana");
var _services_wrapper = _interopRequireDefault(require("../services_wrapper"));
var _translations = require("../osquery_action/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const AttachmentContent = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./external_references_content'))));
const getLazyExternalContent =
// eslint-disable-next-line react/display-name
services => props => {
  const {
    services: {
      application: {
        capabilities: {
          osquery
        }
      }
    }
  } = (0, _kibana.useKibana)();
  if (!osquery.read) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_osquery_icon.OsqueryIcon, null),
      title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.PERMISSION_DENIED),
      titleSize: "xs",
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.osquery.cases.permissionDenied",
        defaultMessage: " To access these results, ask your administrator for {osquery} Kibana privileges."
        // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
        ,
        values: {
          osquery: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "osquery")
        }
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null
  }, /*#__PURE__*/_react.default.createElement(_services_wrapper.default, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(AttachmentContent, props)));
};
exports.getLazyExternalContent = getLazyExternalContent;