"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateSavedQuery = void 0;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _kibana = require("../common/lib/kibana");
var _common = require("../../common");
var _page_paths = require("../common/page_paths");
var _constants = require("./constants");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateSavedQuery = ({
  withRedirect
}) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    application: {
      navigateToApp
    },
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useMutation)(payload => http.post('/api/osquery/saved_queries', {
    body: JSON.stringify(payload)
  }), {
    onError: error => {
      setErrorToast(error, {
        title: error.body.error,
        toastMessage: error.body.message
      });
    },
    onSuccess: response => {
      var _response$data$attrib, _response$data$attrib2;
      queryClient.invalidateQueries([_constants.SAVED_QUERIES_ID]);
      if (withRedirect) {
        navigateToApp(_common.PLUGIN_ID, {
          path: _page_paths.pagePathGetters.saved_queries()
        });
      }
      toasts.addSuccess(_i18n.i18n.translate('xpack.osquery.newSavedQuery.successToastMessageText', {
        defaultMessage: 'Successfully saved "{savedQueryId}" query',
        values: {
          savedQueryId: (_response$data$attrib = (_response$data$attrib2 = response.data.attributes) === null || _response$data$attrib2 === void 0 ? void 0 : _response$data$attrib2.id) !== null && _response$data$attrib !== void 0 ? _response$data$attrib : ''
        }
      }));
    }
  });
};
exports.useCreateSavedQuery = useCreateSavedQuery;