"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedQueriesDropdown = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactHookForm = require("react-hook-form");
var _constants = require("./constants");
var _osquery_schema_link = require("../components/osquery_schema_link");
var _use_saved_queries = require("./use_saved_queries");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TextTruncate = _styledComponents.default.div`
  overflow: hidden;
  text-overflow: ellipsis;
`;
const StyledEuiCodeBlock = (0, _styledComponents.default)(_eui.EuiCodeBlock)`
  .euiCodeBlock__line {
    white-space: nowrap;
  }
`;
const SavedQueriesDropdownComponent = ({
  disabled,
  onChange
}) => {
  var _errors$query;
  const savedQueryId = (0, _reactHookForm.useWatch)({
    name: 'savedQueryId'
  });
  const context = (0, _reactHookForm.useFormContext)();
  const {
    errors
  } = context.formState;
  const queryFieldError = errors === null || errors === void 0 ? void 0 : (_errors$query = errors.query) === null || _errors$query === void 0 ? void 0 : _errors$query.message;
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const {
    data
  } = (0, _use_saved_queries.useSavedQueries)({});
  const queryOptions = (0, _react.useMemo)(() => {
    var _data$data$map, _data$data;
    return (_data$data$map = data === null || data === void 0 ? void 0 : (_data$data = data.data) === null || _data$data === void 0 ? void 0 : _data$data.map(savedQuery => {
      var _savedQuery$attribute;
      return {
        label: (_savedQuery$attribute = savedQuery.attributes.id) !== null && _savedQuery$attribute !== void 0 ? _savedQuery$attribute : '',
        value: {
          savedQueryId: savedQuery.id,
          id: savedQuery.attributes.id,
          description: savedQuery.attributes.description,
          query: savedQuery.attributes.query,
          ecs_mapping: savedQuery.attributes.ecs_mapping
        }
      };
    })) !== null && _data$data$map !== void 0 ? _data$data$map : [];
  }, [data]);
  const handleSavedQueryChange = (0, _react.useCallback)(newSelectedOptions => {
    if (!newSelectedOptions.length) {
      onChange(null);
      setSelectedOptions(newSelectedOptions);
      return;
    }
    const selectedSavedQuery = (0, _fp.find)(['attributes.id', newSelectedOptions[0].value.id], data === null || data === void 0 ? void 0 : data.data);
    if (selectedSavedQuery) {
      onChange({
        ...selectedSavedQuery.attributes,
        savedQueryId: selectedSavedQuery.id
      });
    }
    setSelectedOptions(newSelectedOptions);
  }, [data, onChange]);
  const renderOption = (0, _react.useCallback)(({
    value
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, value.id), /*#__PURE__*/_react.default.createElement(TextTruncate, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, value.description)), /*#__PURE__*/_react.default.createElement(StyledEuiCodeBlock, {
    language: "sql",
    fontSize: "m",
    paddingSize: "s"
  }, value.query.split('\n').join(' '))), []);
  (0, _react.useEffect)(() => {
    if (savedQueryId) {
      const savedQueryOption = (0, _fp.find)(['value.savedQueryId', savedQueryId], queryOptions);
      if (savedQueryOption) {
        setSelectedOptions([savedQueryOption]);
      }
    }
  }, [savedQueryId, queryOptions]);
  (0, _react.useEffect)(() => {
    if (selectedOptions.length && selectedOptions[0].value.savedQueryId !== savedQueryId) {
      setSelectedOptions([]);
    }
  }, [savedQueryId, selectedOptions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !!queryFieldError,
    error: queryFieldError,
    label: _constants.QUERIES_DROPDOWN_SEARCH_FIELD_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_osquery_schema_link.OsquerySchemaLink, null),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": 'savedQuerySelect',
    isDisabled: disabled,
    fullWidth: true,
    placeholder: _constants.QUERIES_DROPDOWN_LABEL
    // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
    ,
    singleSelection: {
      asPlainText: true
    },
    options: queryOptions,
    selectedOptions: selectedOptions,
    onChange: handleSavedQueryChange,
    renderOption: renderOption,
    rowHeight: 110
  }));
};
SavedQueriesDropdownComponent.displayName = 'SavedQueriesDropdown';
const SavedQueriesDropdown = /*#__PURE__*/_react.default.memo(SavedQueriesDropdownComponent);
exports.SavedQueriesDropdown = SavedQueriesDropdown;