"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaygroundFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _live_queries = require("../../live_queries");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiFlyoutHeader = (0, _styledComponents.default)(_eui.EuiFlyoutHeader)`
  &.euiFlyoutHeader {
    padding-top: 21px;
    padding-bottom: 20px;
  }
`;
const PlaygroundFlyoutComponent = ({
  enabled,
  onClose
}) => {
  // @ts-expect-error update types
  const {
    serializer,
    watch
  } = (0, _reactHookForm.useFormContext)();
  const watchedValues = watch();
  const {
    query,
    ecs_mapping: ecsMapping,
    id
  } = watchedValues;
  /* recalculate the form data when ecs_mapping changes */
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const serializedFormData = (0, _react.useMemo)(() => serializer(watchedValues), [ecsMapping]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    type: "push",
    size: "m",
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(StyledEuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.queryPlaygroundFlyout.title",
    defaultMessage: "Test query"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_live_queries.LiveQuery, {
    enabled: enabled && query !== '',
    formType: "simple",
    query: query,
    ecs_mapping: serializedFormData.ecs_mapping,
    savedQueryId: id,
    queryField: false,
    ecsMappingField: false
  })));
};
const PlaygroundFlyout = /*#__PURE__*/_react.default.memo(PlaygroundFlyoutComponent);
exports.PlaygroundFlyout = PlaygroundFlyout;