"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PacksPage = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _layouts = require("../../../components/layouts");
var _packs_table = require("../../../packs/packs_table");
var _add_pack_button = require("../../../packs/add_pack_button");
var _load_integration_assets = require("./load_integration_assets");
var _empty_state = require("./empty_state");
var _use_assets_status = require("../../../assets/use_assets_status");
var _use_packs = require("../../../packs/use_packs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PacksPageComponent = () => {
  var _assetsData$install2;
  const {
    data: assetsData,
    isLoading: isLoadingAssetsStatus
  } = (0, _use_assets_status.useAssetsStatus)();
  const {
    data: packsData,
    isLoading: isLoadingPacks
  } = (0, _use_packs.usePacks)({});
  const showEmptyState = (0, _react.useMemo)(() => {
    var _assetsData$install;
    return !(packsData !== null && packsData !== void 0 && packsData.total) && (assetsData === null || assetsData === void 0 ? void 0 : (_assetsData$install = assetsData.install) === null || _assetsData$install === void 0 ? void 0 : _assetsData$install.length);
  }, [assetsData === null || assetsData === void 0 ? void 0 : (_assetsData$install2 = assetsData.install) === null || _assetsData$install2 === void 0 ? void 0 : _assetsData$install2.length, packsData === null || packsData === void 0 ? void 0 : packsData.total]);
  const LeftColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.packList.pageTitle",
    defaultMessage: "Packs"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.packList.pageSubtitle",
    defaultMessage: "Create packs to organize sets of queries and to schedule queries for agent policies."
  }))))), []);
  const RightColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_load_integration_assets.LoadIntegrationAssetsButton, {
    fill: !!showEmptyState
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_add_pack_button.AddPackButton, {
    fill: !showEmptyState
  }))), [showEmptyState]);
  const Content = (0, _react.useMemo)(() => {
    if (isLoadingAssetsStatus || isLoadingPacks) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
        lines: 10
      });
    }
    if (showEmptyState) {
      return /*#__PURE__*/_react.default.createElement(_empty_state.PacksTableEmptyState, null);
    }
    return /*#__PURE__*/_react.default.createElement(_packs_table.PacksTable, null);
  }, [isLoadingAssetsStatus, isLoadingPacks, showEmptyState]);
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: LeftColumn,
    rightColumn: RightColumn,
    rightColumnGrow: false
  }, Content);
};
const PacksPage = /*#__PURE__*/_react.default.memo(PacksPageComponent);
exports.PacksPage = PacksPage;