"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackDetailsPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _kibana = require("../../../common/lib/kibana");
var _layouts = require("../../../components/layouts");
var _use_pack = require("../../../packs/use_pack");
var _pack_queries_status_table = require("../../../packs/pack_queries_status_table");
var _use_breadcrumbs = require("../../../common/hooks/use_breadcrumbs");
var _use_agent_policy_agent_ids = require("../../../agents/use_agent_policy_agent_ids");
var _packs_table = require("../../../packs/packs_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Divider = _styledComponents.default.div`
  width: 0;
  height: 100%;
  border-left: ${({
  theme
}) => theme.eui.euiBorderThin};
`;
const PackDetailsPageComponent = () => {
  var _data$policy_ids, _data$name;
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const {
    packId
  } = (0, _reactRouterDom.useParams)();
  const packsListProps = (0, _kibana.useRouterNavigate)('packs');
  const editQueryLinkProps = (0, _kibana.useRouterNavigate)(`packs/${packId}/edit`);
  const {
    data
  } = (0, _use_pack.usePack)({
    packId
  });
  const {
    data: agentIds
  } = (0, _use_agent_policy_agent_ids.useAgentPolicyAgentIds)({
    agentPolicyId: data === null || data === void 0 ? void 0 : (_data$policy_ids = data.policy_ids) === null || _data$policy_ids === void 0 ? void 0 : _data$policy_ids[0],
    skip: !data
  });
  (0, _use_breadcrumbs.useBreadcrumbs)('pack_details', {
    packName: (_data$name = data === null || data === void 0 ? void 0 : data.name) !== null && _data$name !== void 0 ? _data$name : ''
  });
  const queriesArray = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = (data === null || data === void 0 ? void 0 : data.queries) && Object.entries(data.queries).map(([id, query]) => ({
      ...query,
      id
    }))) !== null && _ref !== void 0 ? _ref : [];
  }, [data]);
  const LeftColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    iconType: "arrowLeft"
  }, packsListProps, {
    flush: "left",
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.packDetails.viewAllPackListTitle",
    defaultMessage: "View all packs"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.packDetails.pageTitle",
    defaultMessage: "{queryName} details"
    // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
    ,
    values: {
      queryName: data === null || data === void 0 ? void 0 : data.name
    }
  })))), (data === null || data === void 0 ? void 0 : data.description) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, data.description))), [data === null || data === void 0 ? void 0 : data.description, data === null || data === void 0 ? void 0 : data.name, packsListProps]);
  const RightColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: "agents_failed_count"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    textStyle: "reverse",
    style: {
      textAlign: 'right'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textNoWrap"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.packDetailsPage.kpis.policiesLabelText",
    defaultMessage: "Policies"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textNoWrap"
  }, /*#__PURE__*/_react.default.createElement(_packs_table.AgentPoliciesPopover, {
    agentPolicyIds: data === null || data === void 0 ? void 0 : data.policy_ids
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: "agents_failed_count_divider"
  }, /*#__PURE__*/_react.default.createElement(Divider, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: "edit_button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    fill: true
  }, editQueryLinkProps, {
    iconType: "pencil",
    isDisabled: !permissions.writePacks
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.packDetailsPage.editQueryButtonLabel",
    defaultMessage: "Edit"
  })))), [data === null || data === void 0 ? void 0 : data.policy_ids, editQueryLinkProps, permissions]);
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: LeftColumn,
    rightColumn: RightColumn,
    rightColumnGrow: false
  }, data && /*#__PURE__*/_react.default.createElement(_pack_queries_status_table.PackQueriesStatusTable, {
    agentIds: agentIds,
    packName: data.name,
    data: queriesArray
  }));
};
const PackDetailsPage = /*#__PURE__*/_react.default.memo(PackDetailsPageComponent);
exports.PackDetailsPage = PackDetailsPage;