"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _use_all_live_queries = require("./actions/use_all_live_queries");
var _lazy_osquery_action_params_form = require("./shared_components/lazy_osquery_action_params_form");
var _use_fetch_status = require("./fleet_integration/use_fetch_status");
var _lazy_osquery_results = require("./shared_components/lazy_osquery_results");
var _common = require("../common");
var _fleet_integration = require("./fleet_integration");
var _shared_components = require("./shared_components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class OsqueryPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "storage", new _public2.Storage(localStorage));
    this.initializerContext = initializerContext;
    this.kibanaVersion = this.initializerContext.env.packageInfo.version;
  }
  setup(core, plugins) {
    const storage = this.storage;
    const kibanaVersion = this.kibanaVersion;

    // Register an application into the side navigation menu
    core.application.register({
      id: 'osquery',
      title: _common.PLUGIN_NAME,
      order: 9030,
      category: _public.DEFAULT_APP_CATEGORIES.management,
      euiIconType: 'logoOsquery',
      async mount(params) {
        // Get start services as specified in kibana.json
        const [coreStart, depsStart] = await core.getStartServices();
        // Load application bundle
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));

        // Render the application
        return renderApp(coreStart, depsStart, params, storage, kibanaVersion);
      }
    });
    core.getStartServices().then(([coreStart, depsStart]) => {
      var _plugins$cases;
      (_plugins$cases = plugins.cases) === null || _plugins$cases === void 0 ? void 0 : _plugins$cases.attachmentFramework.registerExternalReference((0, _shared_components.getExternalReferenceAttachmentRegular)({
        ...coreStart,
        ...depsStart,
        storage,
        kibanaVersion
      }));
    });

    // Return methods that should be available to other plugins
    return {};
  }
  start(core, plugins) {
    if (plugins.fleet) {
      const {
        registerExtension
      } = plugins.fleet;
      registerExtension({
        package: _common.OSQUERY_INTEGRATION_NAME,
        view: 'package-policy-create',
        Component: _fleet_integration.LazyOsqueryManagedPolicyCreateImportExtension
      });
      registerExtension({
        package: _common.OSQUERY_INTEGRATION_NAME,
        view: 'package-policy-edit',
        Component: _fleet_integration.LazyOsqueryManagedPolicyEditExtension
      });
      registerExtension({
        package: _common.OSQUERY_INTEGRATION_NAME,
        view: 'package-detail-custom',
        Component: _fleet_integration.LazyOsqueryManagedCustomButtonExtension
      });
    }
    return {
      OsqueryAction: (0, _shared_components.getLazyOsqueryAction)({
        ...core,
        ...plugins
      }),
      LiveQueryField: (0, _shared_components.getLazyLiveQueryField)({
        ...core,
        ...plugins
      }),
      OsqueryResults: (0, _lazy_osquery_results.getLazyOsqueryResults)({
        ...core,
        ...plugins,
        storage: this.storage,
        kibanaVersion: this.kibanaVersion
      }),
      OsqueryResponseActionTypeForm: (0, _lazy_osquery_action_params_form.getLazyOsqueryResponseActionTypeForm)(),
      fetchAllLiveQueries: _use_all_live_queries.useAllLiveQueries,
      fetchInstallationStatus: _use_fetch_status.useFetchStatus,
      isOsqueryAvailable: _shared_components.useIsOsqueryAvailableSimple
    };
  }

  // eslint-disable-next-line @typescript-eslint/no-empty-function
  stop() {}
}
exports.OsqueryPlugin = OsqueryPlugin;