"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePackQueryErrors = void 0;
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _kibana = require("../common/lib/kibana");
var _use_logs_data_view = require("../common/hooks/use_logs_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePackQueryErrors = ({
  actionId,
  interval,
  skip = false
}) => {
  const data = (0, _kibana.useKibana)().services.data;
  const {
    data: logsDataView
  } = (0, _use_logs_data_view.useLogsDataView)({
    skip
  });
  return (0, _reactQuery.useQuery)(['scheduledQueryErrors', {
    actionId,
    interval
  }], async () => {
    const searchSource = await data.search.searchSource.create({
      fields: ['*'],
      sort: [{
        '@timestamp': _common.SortDirection.desc
      }],
      query: {
        // @ts-expect-error update types
        bool: {
          filter: [{
            match_phrase: {
              message: 'Error'
            }
          }, {
            match_phrase: {
              'data_stream.dataset': 'elastic_agent.osquerybeat'
            }
          }, {
            match_phrase: {
              message: actionId
            }
          }, {
            range: {
              '@timestamp': {
                gte: `now-${interval * 2}s`,
                lte: 'now'
              }
            }
          }]
        }
      },
      size: 1000
    });
    searchSource.setField('index', logsDataView);
    return (0, _rxjs.lastValueFrom)(searchSource.fetch$());
  }, {
    keepPreviousData: true,
    enabled: !!(!skip && actionId && interval && logsDataView),
    select: response => {
      var _response$rawResponse;
      return (_response$rawResponse = response.rawResponse.hits) !== null && _response$rawResponse !== void 0 ? _response$rawResponse : [];
    },
    refetchOnReconnect: false,
    refetchOnWindowFocus: false
  });
};
exports.usePackQueryErrors = usePackQueryErrors;