"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.idSchemaValidation = exports.idHookSchemaValidation = exports.createFormIdFieldValidations = exports.MAX_QUERY_LENGTH = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_QUERY_LENGTH = 2000;
exports.MAX_QUERY_LENGTH = MAX_QUERY_LENGTH;
const idPattern = /^[a-zA-Z0-9-_]+$/;
// still used in Packs
const idSchemaValidation = ({
  value
}) => {
  const valueIsValid = idPattern.test(value);
  if (!valueIsValid) {
    return {
      message: _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.invalidIdError', {
        defaultMessage: 'Characters must be alphanumeric, _, or -'
      })
    };
  }
};
exports.idSchemaValidation = idSchemaValidation;
const idHookSchemaValidation = value => {
  const valueIsValid = idPattern.test(value);
  if (!valueIsValid) {
    return _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.invalidIdError', {
      defaultMessage: 'Characters must be alphanumeric, _, or -'
    });
  }
};
exports.idHookSchemaValidation = idHookSchemaValidation;
const createUniqueIdValidation = ids => {
  const uniqueIdCheck = value => {
    if (ids.has(value)) {
      return _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.uniqueIdError', {
        defaultMessage: 'ID must be unique'
      });
    }
  };
  return uniqueIdCheck;
};
const createFormIdFieldValidations = ids => ({
  required: {
    message: _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.emptyIdError', {
      defaultMessage: 'ID is required'
    }),
    value: true
  },
  validate: text => {
    const isPatternValid = idHookSchemaValidation(text);
    const isUnique = createUniqueIdValidation(ids)(text);
    return isPatternValid || isUnique;
  }
});
exports.createFormIdFieldValidations = createFormIdFieldValidations;