"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePackQueryForm = void 0;
var _lodash = require("lodash");
var _reactHookForm = require("react-hook-form");
var _immer = require("immer");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deserializer = payload => {
  var _payload$ecs_mapping;
  return {
    id: payload.id,
    query: payload.query,
    interval: payload.interval ? parseInt(payload.interval, 10) : 3600,
    snapshot: payload.snapshot,
    removed: payload.removed,
    platform: payload.platform,
    version: payload.version ? [payload.version] : [],
    ecs_mapping: (_payload$ecs_mapping = payload.ecs_mapping) !== null && _payload$ecs_mapping !== void 0 ? _payload$ecs_mapping : {}
  };
};
const serializer = payload =>
// @ts-expect-error update types
(0, _immer.produce)(payload, draft => {
  if ((0, _lodash.isArray)(draft.platform)) {
    if (draft.platform.length) {
      draft.platform.join(',');
    } else {
      delete draft.platform;
    }
  }
  if ((0, _lodash.isArray)(draft.version)) {
    if (!draft.version.length) {
      delete draft.version;
    } else {
      draft.version = draft.version[0];
    }
  }
  if (draft.interval) {
    draft.interval = draft.interval + '';
  }
  if ((0, _lodash.isEmpty)(draft.ecs_mapping)) {
    delete draft.ecs_mapping;
  }
  return draft;
});
const usePackQueryForm = ({
  uniqueQueryIds,
  defaultValue
}) => {
  const idSet = (0, _react.useMemo)(() => new Set((0, _lodash.xor)(uniqueQueryIds, defaultValue !== null && defaultValue !== void 0 && defaultValue.id ? [defaultValue.id] : [])), [uniqueQueryIds, defaultValue]);
  return {
    serializer,
    idSet,
    ...(0, _reactHookForm.useForm)({
      defaultValues: defaultValue ? deserializer(defaultValue) : {
        id: '',
        query: '',
        interval: 3600,
        snapshot: true,
        removed: false
      }
    })
  };
};
exports.usePackQueryForm = usePackQueryForm;