"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PacksTable = exports.AgentPoliciesPopover = void 0;
var _eui = require("@elastic/eui");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _kibana = require("../common/lib/kibana");
var _use_packs = require("./use_packs");
var _active_state_switch = require("./active_state_switch");
var _agents_policy_link = require("../agent_policies/agents_policy_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpdatedBy = _styledComponents.default.span`
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
`;
const EMPTY_ARRAY = [];
const ScheduledQueryNameComponent = ({
  id,
  name
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _kibana.useRouterNavigate)(`packs/${id}`), name);
const ScheduledQueryName = /*#__PURE__*/_react.default.memo(ScheduledQueryNameComponent);
const renderName = (_, item) => /*#__PURE__*/_react.default.createElement(ScheduledQueryName, {
  id: item.id,
  name: item.attributes.name
});
const AgentPoliciesPopover = ({
  agentPolicyIds = []
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(currentIsPopoverOpen => !currentIsPopoverOpen), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const button = (0, _react.useMemo)(() => {
    var _agentPolicyIds$lengt;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "both",
      onClick: onButtonClick
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_agentPolicyIds$lengt = agentPolicyIds === null || agentPolicyIds === void 0 ? void 0 : agentPolicyIds.length) !== null && _agentPolicyIds$lengt !== void 0 ? _agentPolicyIds$lengt : 0));
  }, [agentPolicyIds === null || agentPolicyIds === void 0 ? void 0 : agentPolicyIds.length, onButtonClick]);
  if (!(agentPolicyIds !== null && agentPolicyIds !== void 0 && agentPolicyIds.length)) {
    var _agentPolicyIds$lengt2;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_agentPolicyIds$lengt2 = agentPolicyIds === null || agentPolicyIds === void 0 ? void 0 : agentPolicyIds.length) !== null && _agentPolicyIds$lengt2 !== void 0 ? _agentPolicyIds$lengt2 : 0);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, agentPolicyIds === null || agentPolicyIds === void 0 ? void 0 : agentPolicyIds.map(policyId => /*#__PURE__*/_react.default.createElement("div", {
    key: policyId
  }, /*#__PURE__*/_react.default.createElement(_agents_policy_link.AgentsPolicyLink, {
    policyId: policyId
  })))));
};
exports.AgentPoliciesPopover = AgentPoliciesPopover;
const PacksTableComponent = () => {
  var _data$data;
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const {
    push
  } = (0, _reactRouterDom.useHistory)();
  const {
    data,
    isLoading
  } = (0, _use_packs.usePacks)({});
  const renderAgentPolicy = (0, _react.useCallback)(agentPolicyIds => /*#__PURE__*/_react.default.createElement(AgentPoliciesPopover, {
    agentPolicyIds: agentPolicyIds
  }), []);
  const renderQueries = (0, _react.useCallback)(queries => {
    var _ref;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_ref = queries && Object.keys(queries).length) !== null && _ref !== void 0 ? _ref : 0);
  }, []);
  const renderActive = (0, _react.useCallback)((_, item) => /*#__PURE__*/_react.default.createElement(_active_state_switch.ActiveStateSwitch, {
    item: item
  }), []);
  const renderUpdatedAt = (0, _react.useCallback)((updatedAt, item) => {
    if (!updatedAt) return '-';
    const updatedBy = item.attributes.updated_by !== item.attributes.created_by ? ` @ ${item.attributes.updated_by}` : '';
    return updatedAt ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: `${(0, _momentTimezone.default)(updatedAt).fromNow()}${updatedBy}`
    }, /*#__PURE__*/_react.default.createElement(UpdatedBy, null, `${(0, _momentTimezone.default)(updatedAt).fromNow()}${updatedBy}`)) : '-';
  }, []);
  const handlePlayClick = (0, _react.useCallback)(item => () => push('/live_queries/new', {
    form: {
      packId: item.id
    }
  }), [push]);
  const renderPlayAction = (0, _react.useCallback)((item, enabled) => {
    const playText = _i18n.i18n.translate('xpack.osquery.packs.table.runActionAriaLabel', {
      defaultMessage: 'Run {packName}',
      values: {
        packName: item.attributes.name
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: playText
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "play",
      onClick: handlePlayClick(item),
      isDisabled: !enabled
    }));
  }, [handlePlayClick]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'attributes.name',
    name: _i18n.i18n.translate('xpack.osquery.packs.table.nameColumnTitle', {
      defaultMessage: 'Name'
    }),
    sortable: item => item.attributes.name.toLowerCase(),
    render: renderName
  }, {
    field: 'policy_ids',
    name: _i18n.i18n.translate('xpack.osquery.packs.table.policyColumnTitle', {
      defaultMessage: 'Scheduled policies'
    }),
    truncateText: true,
    render: renderAgentPolicy
  }, {
    field: 'attributes.queries',
    name: _i18n.i18n.translate('xpack.osquery.packs.table.numberOfQueriesColumnTitle', {
      defaultMessage: 'Number of queries'
    }),
    render: renderQueries,
    width: '150px'
  }, {
    field: 'attributes.created_by',
    name: _i18n.i18n.translate('xpack.osquery.packs.table.createdByColumnTitle', {
      defaultMessage: 'Created by'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'attributes.updated_at',
    name: 'Last updated',
    sortable: item => item.updated_at ? Date.parse(item.updated_at) : 0,
    truncateText: true,
    render: renderUpdatedAt
  }, {
    field: 'attributes.enabled',
    name: _i18n.i18n.translate('xpack.osquery.packs.table.activeColumnTitle', {
      defaultMessage: 'Active'
    }),
    sortable: true,
    align: 'right',
    width: '80px',
    render: renderActive
  }, {
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    width: '80px',
    actions: [{
      render: renderPlayAction,
      enabled: () => permissions.writeLiveQueries || permissions.runSavedQueries
    }]
  }], [permissions.runSavedQueries, permissions.writeLiveQueries, renderActive, renderAgentPolicy, renderPlayAction, renderQueries, renderUpdatedAt]);
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: 'attributes.name',
      direction: 'asc'
    }
  }), []);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
      lines: 10
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: (_data$data = data === null || data === void 0 ? void 0 : data.data) !== null && _data$data !== void 0 ? _data$data : EMPTY_ARRAY,
    columns: columns,
    pagination: true,
    sorting: sorting
  });
};
const PacksTable = /*#__PURE__*/_react.default.memo(PacksTableComponent);
exports.PacksTable = PacksTable;