"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _reactHookForm = require("react-hook-form");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _pack_shards_field = require("./shards/pack_shards_field");
var _kibana = require("../../common/lib/kibana");
var _policy_id_combobox_field = require("./policy_id_combobox_field");
var _queries_field = require("./queries_field");
var _confirmation_modal = require("./confirmation_modal");
var _agent_policies = require("../../agent_policies");
var _use_create_pack = require("../use_create_pack");
var _use_update_pack = require("../use_update_pack");
var _utils = require("./utils");
var _name_field = require("./name_field");
var _description_field = require("./description_field");
var _pack_type_selectable = require("./shards/pack_type_selectable");
var _utils2 = require("../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  ${({
  isDisabled
}) => isDisabled && 'display: none;'}
  .euiAccordion__button {
    color: ${({
  theme
}) => theme.eui.euiColorPrimary};
  }
`;
const PackFormComponent = ({
  defaultValue,
  editMode = false,
  isReadOnly = false
}) => {
  const [shardsToggleState, setShardsToggleState] = (0, _react.useState)('closed');
  const handleToggle = (0, _react.useCallback)(isOpen => {
    const newState = isOpen ? 'open' : 'closed';
    setShardsToggleState(newState);
  }, []);
  const [packType, setPackType] = (0, _react.useState)('policy');
  const [showConfirmationModal, setShowConfirmationModal] = (0, _react.useState)(false);
  const handleHideConfirmationModal = (0, _react.useCallback)(() => setShowConfirmationModal(false), []);
  const {
    data: {
      agentPoliciesById
    } = {}
  } = (0, _agent_policies.useAgentPolicies)();
  const cancelButtonProps = (0, _kibana.useRouterNavigate)(`packs/${editMode ? defaultValue === null || defaultValue === void 0 ? void 0 : defaultValue.id : ''}`);
  const {
    mutateAsync: createAsync
  } = (0, _use_create_pack.useCreatePack)({
    withRedirect: true
  });
  const {
    mutateAsync: updateAsync
  } = (0, _use_update_pack.useUpdatePack)({
    withRedirect: true
  });
  const deserializer = payload => {
    var _omit;
    const defaultPolicyIds = (0, _lodash.filter)(payload.policy_ids, policyId => {
      var _payload$shards;
      return ((_payload$shards = payload.shards) === null || _payload$shards === void 0 ? void 0 : _payload$shards[policyId]) == null;
    });
    return {
      ...payload,
      policy_ids: defaultPolicyIds !== null && defaultPolicyIds !== void 0 ? defaultPolicyIds : [],
      queries: (0, _utils.convertPackQueriesToSO)(payload.queries),
      shards: (_omit = (0, _lodash.omit)(payload.shards, '*')) !== null && _omit !== void 0 ? _omit : {}
    };
  };
  const hooksForm = (0, _reactHookForm.useForm)({
    defaultValues: defaultValue ? deserializer(defaultValue) : {
      name: '',
      description: '',
      policy_ids: [],
      enabled: true,
      queries: []
    }
  });
  (0, _react.useEffect)(() => {
    if (!(0, _lodash.isEmpty)(defaultValue === null || defaultValue === void 0 ? void 0 : defaultValue.shards)) {
      var _defaultValue$shards;
      if (defaultValue !== null && defaultValue !== void 0 && (_defaultValue$shards = defaultValue.shards) !== null && _defaultValue$shards !== void 0 && _defaultValue$shards['*']) {
        setPackType('global');
      } else {
        setShardsToggleState('open');
      }
    }
  }, [defaultValue, defaultValue === null || defaultValue === void 0 ? void 0 : defaultValue.shards]);
  const {
    handleSubmit,
    watch,
    formState: {
      isSubmitting
    }
  } = hooksForm;
  const {
    policy_ids: policyIds,
    shards
  } = watch();
  const getShards = (0, _react.useCallback)(() => {
    if (packType === 'global') {
      return {
        '*': 100
      };
    }
    return (0, _lodash.reduce)(shards, (acc, shard, key) => {
      if (!(0, _lodash.isEmpty)(key)) {
        return {
          ...acc,
          [key]: shard
        };
      }
      return acc;
    }, {});
  }, [packType, shards]);
  const onSubmit = (0, _react.useCallback)(async values => {
    const serializer = ({
      shards: _,
      policy_ids: payloadAgentPolicyIds,
      queries,
      ...restPayload
    }) => {
      var _getShards;
      const mappedShards = !(0, _lodash.isEmpty)(shards) ? (0, _lodash.filter)((0, _lodash.map)(shards, (shard, key) => {
        if (!(0, _lodash.isEmpty)(key)) {
          return key;
        }
      })) : [];
      const policies = [...payloadAgentPolicyIds, ...mappedShards];
      return {
        ...restPayload,
        policy_ids: policies !== null && policies !== void 0 ? policies : [],
        queries: (0, _utils.convertSOQueriesToPack)(queries),
        shards: (_getShards = getShards()) !== null && _getShards !== void 0 ? _getShards : {}
      };
    };
    try {
      if (editMode && defaultValue !== null && defaultValue !== void 0 && defaultValue.id) {
        await updateAsync({
          id: defaultValue === null || defaultValue === void 0 ? void 0 : defaultValue.id,
          ...serializer(values)
        });
      } else {
        await createAsync(serializer(values));
      }
      // eslint-disable-next-line no-empty
    } catch (e) {}
  }, [createAsync, defaultValue === null || defaultValue === void 0 ? void 0 : defaultValue.id, editMode, getShards, shards, updateAsync]);
  const handleSubmitForm = (0, _react.useMemo)(() => handleSubmit(onSubmit), [handleSubmit, onSubmit]);
  const agentCount = (0, _react.useMemo)(() => (0, _lodash.reduce)(policyIds, (acc, policyId) => {
    var _agentPolicy$agents;
    const agentPolicy = agentPoliciesById && agentPoliciesById[policyId];
    return acc + ((_agentPolicy$agents = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.agents) !== null && _agentPolicy$agents !== void 0 ? _agentPolicy$agents : 0);
  }, 0), [policyIds, agentPoliciesById]);
  const handleSaveClick = (0, _react.useCallback)(() => {
    if (agentCount) {
      setShowConfirmationModal(true);
      return;
    }
    handleSubmitForm();
  }, [agentCount, handleSubmitForm]);
  const handleConfirmConfirmationClick = (0, _react.useCallback)(() => {
    handleSubmitForm();
    setShowConfirmationModal(false);
  }, [handleSubmitForm]);
  const euiFieldProps = (0, _react.useMemo)(() => ({
    isDisabled: isReadOnly
  }), [isReadOnly]);
  const changePackType = (0, _react.useCallback)(type => {
    setPackType(type);
  }, [setPackType]);
  const options = (0, _react.useMemo)(() => Object.entries(agentPoliciesById !== null && agentPoliciesById !== void 0 ? agentPoliciesById : {}).map(([agentPolicyId, agentPolicy]) => ({
    key: agentPolicyId,
    label: agentPolicy.name
  })), [agentPoliciesById]);
  const availableOptions = (0, _react.useMemo)(() => {
    const currentShardsFieldValues = (0, _lodash.map)(shards, (shard, key) => key);
    const currentPolicyIdsFieldValues = (0, _lodash.map)(policyIds, policy => policy);
    const currentValues = [...currentShardsFieldValues, ...currentPolicyIdsFieldValues];
    return options.filter(({
      key
    }) => !currentValues.includes(key));
  }, [shards, policyIds, options]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, hooksForm, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_name_field.NameField, {
    euiFieldProps: euiFieldProps
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_description_field.DescriptionField, {
    euiFieldProps: euiFieldProps
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_pack_type_selectable.PackTypeSelectable, {
    packType: packType,
    setPackType: changePackType
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), packType === 'policy' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _utils2.overflowCss
  }, /*#__PURE__*/_react.default.createElement(_policy_id_combobox_field.PolicyIdComboBoxField, {
    options: availableOptions
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _utils2.overflowCss
  }, /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    id: "shardsToggle",
    forceState: shardsToggleState,
    onToggle: handleToggle,
    buttonContent: "Partial deployment (shards)"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_pack_shards_field.PackShardsField, {
    options: availableOptions
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_queries_field.QueriesField, {
    euiFieldProps: euiFieldProps
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    color: "ghost"
  }, cancelButtonProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.form.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isSubmitting,
    color: "primary",
    fill: true,
    size: "m",
    iconType: "save",
    onClick: handleSaveClick
  }, editMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.form.updatePackButtonLabel",
    defaultMessage: "Update pack"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.form.savePackButtonLabel",
    defaultMessage: "Save pack"
  }))))))), showConfirmationModal && /*#__PURE__*/_react.default.createElement(_confirmation_modal.ConfirmDeployAgentPolicyModal, {
    onCancel: handleHideConfirmationModal,
    onConfirm: handleConfirmConfirmationClick,
    agentCount: agentCount,
    agentPolicyCount: policyIds.length
  }));
};
const PackForm = /*#__PURE__*/_react.default.memo(PackFormComponent, _fastDeepEqual.default);
exports.PackForm = PackForm;