"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LiveQuery = void 0;
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _replace_params_query = require("../../common/utils/replace_params_query");
var _contexts = require("../common/contexts");
var _form = require("./form");
var _use_action_privileges = require("../action_results/use_action_privileges");
var _common = require("../../common");
var _osquery_icon = require("../components/osquery_icon");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LiveQueryComponent = ({
  agentId,
  agentIds,
  alertIds,
  agentPolicyIds,
  onSuccess,
  query,
  savedQueryId,
  // eslint-disable-next-line @typescript-eslint/naming-convention
  ecs_mapping,
  queryField,
  ecsMappingField,
  formType,
  enabled,
  hideAgentsField,
  packId,
  agentSelection
}) => {
  const {
    data: hasActionResultsPrivileges,
    isLoading
  } = (0, _use_action_privileges.useActionResultsPrivileges)();
  const initialAgentSelection = (0, _react.useMemo)(() => {
    if (agentSelection) {
      return agentSelection;
    }
    if (agentId || agentPolicyIds !== null && agentPolicyIds !== void 0 && agentPolicyIds.length) {
      var _ref;
      return {
        allAgentsSelected: false,
        agents: (0, _lodash.castArray)((_ref = agentId !== null && agentId !== void 0 ? agentId : agentIds) !== null && _ref !== void 0 ? _ref : []),
        platformsSelected: [],
        policiesSelected: agentPolicyIds !== null && agentPolicyIds !== void 0 ? agentPolicyIds : []
      };
    }
    return null;
  }, [agentId, agentIds, agentPolicyIds, agentSelection]);
  const ecsData = (0, _react.useContext)(_contexts.AlertAttachmentContext);
  const initialQuery = (0, _react.useMemo)(() => {
    if (ecsData && query) {
      const {
        result
      } = (0, _replace_params_query.replaceParamsQuery)(query, ecsData);
      return result;
    }
    return query;
  }, [ecsData, query]);
  const defaultValue = (0, _react.useMemo)(() => {
    const initialValue = {
      ...(initialAgentSelection ? {
        agentSelection: initialAgentSelection
      } : {}),
      alertIds,
      query: initialQuery,
      savedQueryId,
      ecs_mapping,
      packId
    };
    return !(0, _lodash.isEmpty)((0, _lodash.pickBy)(initialValue, value => !(0, _lodash.isEmpty)(value))) ? initialValue : undefined;
  }, [alertIds, ecs_mapping, initialAgentSelection, initialQuery, packId, savedQueryId]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
      lines: 10
    });
  }
  if (!hasActionResultsPrivileges) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_osquery_icon.OsqueryIcon, null),
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.osquery.liveQuery.permissionDeniedPromptTitle",
        defaultMessage: "Permission denied"
      })),
      titleSize: "xs",
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.osquery.liveQuery.permissionDeniedPromptBody",
        defaultMessage: "To view query results, ask your administrator to update your user role to have index {read} privileges on the {logs} index."
        // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
        ,
        values: {
          read: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "read"),
          logs: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "logs-", _common.OSQUERY_INTEGRATION_NAME, ".result*")
        }
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_form.LiveQueryForm, {
    queryField: queryField,
    ecsMappingField: ecsMappingField,
    defaultValue: defaultValue,
    onSuccess: onSuccess,
    formType: formType,
    enabled: enabled,
    hideAgentsField: hideAgentsField
  });
};
const LiveQuery = /*#__PURE__*/_react.default.memo(LiveQueryComponent);
exports.LiveQuery = LiveQuery;