"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryPackSelectable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactHookForm = require("react-hook-form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiCard = (0, _styledComponents.default)(_eui.EuiCard)`
  padding: 0;
  display: flex;
  flex-direction: row;
  border: ${props => {
  var _props$selectable;
  if ((_props$selectable = props.selectable) !== null && _props$selectable !== void 0 && _props$selectable.isSelected) {
    return `1px solid ${props.theme.eui.euiColorSuccess}`;
  }
}};
  .euiCard__content {
    padding: 16px 92px 16px 16px !important;
  }
  .euiTitle {
    font-size: 1rem;
  }
  .euiText {
    margin-top: 0;
    color: ${props => props.theme.eui.euiTextSubduedColor};
  }

  > button[role='switch'] {
    min-inline-size: 80px;
    height: 100% !important;
    width: 80px;
    border-radius: 0 5px 5px 0;

    > span {
      > svg {
        width: 18px;
        height: 18px;
        display: inline-block !important;
      }

      // hide the label
      > :not(svg) {
        display: none;
      }
    }
  }
`;
const QueryPackSelectable = ({
  canRunSingleQuery,
  canRunPacks
}) => {
  const {
    field: {
      value: queryType,
      onChange: setQueryType
    }
  } = (0, _reactHookForm.useController)({
    name: 'queryType',
    defaultValue: 'query',
    rules: {
      deps: ['packId', 'query']
    }
  });
  const handleChange = (0, _react.useCallback)(type => {
    setQueryType(type);
  }, [setQueryType]);
  const queryCardSelectable = (0, _react.useMemo)(() => ({
    onClick: () => handleChange('query'),
    isSelected: queryType === 'query',
    iconType: 'check',
    textProps: {} // this is needed for the text to get wrapped in span
  }), [queryType, handleChange]);
  const packCardSelectable = (0, _react.useMemo)(() => ({
    onClick: () => handleChange('pack'),
    isSelected: queryType === 'pack',
    iconType: 'check',
    textProps: {} // this is needed for the text to get wrapped in span
  }), [queryType, handleChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Query type",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StyledEuiCard, {
    layout: "horizontal",
    title: _i18n.i18n.translate('xpack.osquery.liveQuery.queryForm.singleQueryTypeLabel', {
      defaultMessage: 'Single query'
    }),
    titleSize: "xs",
    hasBorder: true,
    description: _i18n.i18n.translate('xpack.osquery.liveQuery.queryForm.singleQueryTypeDescription', {
      defaultMessage: 'Run a saved query or new one.'
    }),
    selectable: queryCardSelectable,
    isDisabled: !canRunSingleQuery
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StyledEuiCard, {
    layout: "horizontal",
    title: _i18n.i18n.translate('xpack.osquery.liveQuery.queryForm.packQueryTypeLabel', {
      defaultMessage: 'Pack'
    }),
    titleSize: "xs",
    hasBorder: true,
    description: _i18n.i18n.translate('xpack.osquery.liveQuery.queryForm.packQueryTypeDescription', {
      defaultMessage: 'Run a set of queries in a pack.'
    }),
    selectable: packCardSelectable,
    isDisabled: !canRunPacks
  })))));
};
exports.QueryPackSelectable = QueryPackSelectable;