"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultsTypeField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _i18nReact = require("@kbn/i18n-react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SNAPSHOT_OPTION = {
  value: 'snapshot',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.queryFlyoutForm.resultsTypeField.snapshotValueLabel",
    defaultMessage: "Snapshot"
  })
};
const DIFFERENTIAL_OPTION = {
  value: 'differential',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.queryFlyoutForm.resultsTypeField.differentialValueLabel",
    defaultMessage: "Differential"
  })
};
const DIFFERENTIAL_ADDED_ONLY_OPTION = {
  value: 'added_only',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.queryFlyoutForm.resultsTypeField.differentialAddedOnlyValueLabel",
    defaultMessage: "Differential (Ignore removals)"
  })
};
const FIELD_OPTIONS = [SNAPSHOT_OPTION, DIFFERENTIAL_OPTION, DIFFERENTIAL_ADDED_ONLY_OPTION];
const ResultsTypeFieldComponent = ({
  euiFieldProps = {}
}) => {
  const [selectedOption, setSelectedOption] = (0, _react.useState)(SNAPSHOT_OPTION.value);
  const {
    defaultValues
  } = (0, _reactHookForm.useFormState)();
  const {
    field: {
      onChange: onSnapshotChange,
      value: snapshotValue
    }
  } = (0, _reactHookForm.useController)({
    name: 'snapshot',
    defaultValue: defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues.snapshot
  });
  const {
    field: {
      onChange: onRemovedChange,
      value: removedValue
    }
  } = (0, _reactHookForm.useController)({
    name: 'removed',
    defaultValue: defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues.removed
  });
  const handleChange = (0, _react.useCallback)(newValue => {
    if (newValue === SNAPSHOT_OPTION.value) {
      onSnapshotChange(true);
      onRemovedChange(false);
    }
    if (newValue === DIFFERENTIAL_OPTION.value) {
      onSnapshotChange(false);
      onRemovedChange(true);
    }
    if (newValue === DIFFERENTIAL_ADDED_ONLY_OPTION.value) {
      onSnapshotChange(false);
      onRemovedChange(false);
    }
  }, [onRemovedChange, onSnapshotChange]);
  (0, _react.useEffect)(() => {
    setSelectedOption(() => {
      if (snapshotValue) {
        return SNAPSHOT_OPTION.value;
      }
      if (!snapshotValue && removedValue) {
        return DIFFERENTIAL_OPTION.value;
      }
      if (!snapshotValue && !removedValue) {
        return DIFFERENTIAL_ADDED_ONLY_OPTION.value;
      }
      return SNAPSHOT_OPTION.value;
    });
  }, [removedValue, snapshotValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.pack.queryFlyoutForm.resultTypeFieldLabel",
      defaultMessage: "Result type"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: _i18n.i18n.translate('xpack.osquery.betaBadgeLabel', {
        defaultMessage: 'Beta'
      }),
      size: "s"
    }))),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.queryFlyoutForm.fieldOptionalLabel",
      defaultMessage: "(optional)"
    }))),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, (0, _extends2.default)({
    "data-test-subj": 'resultsTypeField',
    options: FIELD_OPTIONS,
    fullWidth: true,
    valueOfSelected: selectedOption,
    onChange: handleChange
  }, euiFieldProps)));
};
const ResultsTypeField = /*#__PURE__*/_react.default.memo(ResultsTypeFieldComponent, _fastDeepEqual.default);
exports.ResultsTypeField = ResultsTypeField;