"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavigationButtons = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../common");
var _kibana = require("../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NavigationButtonsComponent = ({
  isDisabled = false,
  agentPolicyId
}) => {
  const {
    application: {
      getUrlForApp,
      navigateToApp
    }
  } = (0, _kibana.useKibana)().services;
  const liveQueryHref = (0, _react.useMemo)(() => getUrlForApp(_common.PLUGIN_ID, {
    path: agentPolicyId ? `/live_queries/new?agentPolicyId=${agentPolicyId}` : '/live_queries/new'
  }), [agentPolicyId, getUrlForApp]);
  const liveQueryClick = (0, _react.useCallback)(event => {
    if (!(0, _kibana.isModifiedEvent)(event) && (0, _kibana.isLeftClickEvent)(event)) {
      event.preventDefault();
      navigateToApp(_common.PLUGIN_ID, {
        path: agentPolicyId ? `/live_queries/new?agentPolicyId=${agentPolicyId}` : '/live_queries/new'
      });
    }
  }, [agentPolicyId, navigateToApp]);
  const packsHref = getUrlForApp(_common.PLUGIN_ID, {
    path: `/packs`
  });
  const packsClick = (0, _react.useCallback)(event => {
    if (!(0, _kibana.isModifiedEvent)(event) && (0, _kibana.isLeftClickEvent)(event)) {
      event.preventDefault();
      navigateToApp(_common.PLUGIN_ID, {
        path: `/packs`
      });
    }
  }, [navigateToApp]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "console"
    }),
    title: _i18n.i18n.translate('xpack.osquery.fleetIntegration.runLiveQueriesButtonText', {
      defaultMessage: 'Run live queries'
    }),
    href: liveQueryHref,
    onClick: liveQueryClick,
    description: '',
    isDisabled: isDisabled
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "clock"
    }),
    title: _i18n.i18n.translate('xpack.osquery.fleetIntegration.packsButtonText', {
      defaultMessage: 'Packs'
    }),
    description: '',
    isDisabled: isDisabled,
    href: packsHref,
    onClick: packsClick
  })));
};
NavigationButtonsComponent.displayName = 'NavigationButtonsComponent';
const NavigationButtons = /*#__PURE__*/_react.default.memo(NavigationButtonsComponent);
exports.NavigationButtons = NavigationButtons;