"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../shared_imports");
require("./osquery_mode");
require("brace/theme/tomorrow");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EDITOR_SET_OPTIONS = {
  enableBasicAutocompletion: true,
  enableLiveAutocompletion: true
};
const EDITOR_PROPS = {
  $blockScrolling: true
};
const ResizeWrapper = _styledComponents.default.div`
  overflow: auto;
  resize: vertical;
  min-height: 100px;
`;
const MIN_HEIGHT = 100;
const OsqueryEditorComponent = ({
  defaultValue,
  onChange,
  commands
}) => {
  const [editorValue, setEditorValue] = (0, _react.useState)(defaultValue !== null && defaultValue !== void 0 ? defaultValue : '');
  const [height, setHeight] = (0, _react.useState)(MIN_HEIGHT);
  const editorRef = (0, _react.useRef)({
    renderer: {
      layerConfig: {
        maxHeight: 100,
        minHeight: 100
      }
    }
  });
  (0, _useDebounce.default)(() => {
    var _editorRef$current;
    onChange(editorValue);
    const config = (_editorRef$current = editorRef.current) === null || _editorRef$current === void 0 ? void 0 : _editorRef$current.renderer.layerConfig;
    if (config.maxHeight > config.minHeight) {
      setHeight(config.maxHeight);
    }
  }, 500, [editorValue]);
  (0, _react.useEffect)(() => setEditorValue(defaultValue), [defaultValue]);
  const resizeEditor = (0, _react.useCallback)(editorInstance => {
    editorRef.current.renderer = editorInstance.renderer;
    setTimeout(() => {
      const {
        maxHeight
      } = editorInstance.renderer.layerConfig;
      if (maxHeight > MIN_HEIGHT) {
        setHeight(maxHeight);
      }
    }, 0);
  }, []);
  const onResize = (0, _react.useCallback)(dimensions => {
    setHeight(dimensions.height);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: onResize
  }, resizeRef => /*#__PURE__*/_react.default.createElement(ResizeWrapper, {
    ref: resizeRef
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.EuiCodeEditor, {
    value: editorValue,
    mode: "osquery",
    onChange: setEditorValue,
    theme: "tomorrow",
    name: "osquery_editor",
    setOptions: EDITOR_SET_OPTIONS,
    editorProps: EDITOR_PROPS,
    onLoad: resizeEditor,
    height: height + 'px',
    width: "100%",
    commands: commands
  })));
};
const OsqueryEditor = /*#__PURE__*/_react.default.memo(OsqueryEditorComponent);
exports.OsqueryEditor = OsqueryEditor;