"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageIntegrationLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _kibana = require("../common/lib/kibana");
var _common2 = require("../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManageIntegrationLinkComponent = () => {
  const {
    application: {
      getUrlForApp,
      navigateToApp
    }
  } = (0, _kibana.useKibana)().services;
  const integrationHref = (0, _react.useMemo)(() => getUrlForApp(_common.INTEGRATIONS_PLUGIN_ID, {
    path: _public.pagePathGetters.integration_details_policies({
      pkgkey: _common2.OSQUERY_INTEGRATION_NAME
    })[1]
  }), [getUrlForApp]);
  const integrationClick = (0, _react.useCallback)(event => {
    if (!(0, _kibana.isModifiedEvent)(event) && (0, _kibana.isLeftClickEvent)(event)) {
      event.preventDefault();
      return navigateToApp(_common.INTEGRATIONS_PLUGIN_ID, {
        path: _public.pagePathGetters.integration_details_policies({
          pkgkey: _common2.OSQUERY_INTEGRATION_NAME
        })[1]
      });
    }
  }, [navigateToApp]);
  return integrationHref ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null,
  /*#__PURE__*/
  // eslint-disable-next-line @elastic/eui/href-or-on-click
  _react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "gear",
    href: integrationHref,
    onClick: integrationClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.appNavigation.manageIntegrationButton",
    defaultMessage: "Manage integration"
  }))) : null;
};
const ManageIntegrationLink = /*#__PURE__*/_react.default.memo(ManageIntegrationLinkComponent);
exports.ManageIntegrationLink = ManageIntegrationLink;