"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Wrapper = exports.Nav = exports.Container = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = _styledComponents.default.div`
  min-height: calc(
    100vh - ${props => parseFloat(props.theme.eui.euiHeaderHeightCompensation) * 2}px
  );
  background: ${props => props.theme.eui.euiColorEmptyShade};
  display: flex;
  flex-direction: column;
`;
exports.Container = Container;
const Wrapper = _styledComponents.default.div`
  display: flex;
  flex-direction: column;
  flex: 1;
`;
exports.Wrapper = Wrapper;
const Nav = _styledComponents.default.nav`
  background: ${props => props.theme.eui.euiColorEmptyShade};
  border-bottom: ${props => props.theme.eui.euiBorderThin};
  padding: ${props => `${props.theme.eui.euiSize} ${props.theme.eui.euiSizeL} ${props.theme.eui.euiSize} ${props.theme.eui.euiSizeL}`};
  .euiTabs {
    padding-left: 3px;
    margin-left: -3px;
  }
`;
exports.Nav = Nav;