"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInspectResponse = exports.generateTablePaginationOptions = exports.createFilter = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFilter = filterQuery => (0, _fp.isString)(filterQuery) ? filterQuery : JSON.stringify(filterQuery);
exports.createFilter = createFilter;
const generateTablePaginationOptions = (activePage, limit) => {
  const cursorStart = activePage * limit;
  return {
    activePage,
    cursorStart,
    querySize: limit
  };
};
exports.generateTablePaginationOptions = generateTablePaginationOptions;
const getInspectResponse = (response, prevResponse) => {
  var _ref, _response$inspect$dsl, _response$inspect;
  return {
    dsl: (_ref = (_response$inspect$dsl = response === null || response === void 0 ? void 0 : (_response$inspect = response.inspect) === null || _response$inspect === void 0 ? void 0 : _response$inspect.dsl) !== null && _response$inspect$dsl !== void 0 ? _response$inspect$dsl : prevResponse === null || prevResponse === void 0 ? void 0 : prevResponse.dsl) !== null && _ref !== void 0 ? _ref : [],
    response: response != null ? [JSON.stringify(response.rawResponse, null, 2)] : prevResponse === null || prevResponse === void 0 ? void 0 : prevResponse.response
  };
};
exports.getInspectResponse = getInspectResponse;