"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToCaseWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _pack_queries_attachment_wrapper = require("../shared_components/attachments/pack_queries_attachment_wrapper");
var _kibana = require("../common/lib/kibana");
var _add_to_cases_button = require("./add_to_cases_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CASES_OWNER = [];
const AddToCaseWrapper = /*#__PURE__*/_react.default.memo(props => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const isCasesAttachment = (0, _react.useContext)(_pack_queries_attachment_wrapper.CasesAttachmentWrapperContext);
  if (isCasesAttachment || !props.actionId) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const casePermissions = cases.helpers.canUseCases();
  const CasesContext = cases.ui.getCasesContext();
  return /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: CASES_OWNER,
    permissions: casePermissions
  }, /*#__PURE__*/_react.default.createElement(_add_to_cases_button.AddToCaseButton, props));
});
exports.AddToCaseWrapper = AddToCaseWrapper;
AddToCaseWrapper.displayName = 'AddToCaseWrapper';