"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentPolicies = void 0;
var _lodash = require("lodash");
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _kibana = require("../common/lib/kibana");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentPolicies = (policyIds = []) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  const agentResponse = (0, _reactQuery.useQueries)({
    queries: policyIds.map(policyId => ({
      queryKey: ['agentPolicy', policyId],
      queryFn: () => http.get(`/internal/osquery/fleet_wrapper/agent_policies/${policyId}`),
      enabled: policyIds.length > 0,
      onSuccess: () => setErrorToast(),
      onError: error => setErrorToast(error, {
        title: _i18n.i18n.translate('xpack.osquery.action_policy_details.fetchError', {
          defaultMessage: 'Error while fetching policy details'
        })
      })
    }))
  });
  const agentPoliciesLoading = agentResponse.some(p => p.isLoading);
  const agentPolicies = agentResponse.map(p => {
    var _p$data;
    return (_p$data = p.data) === null || _p$data === void 0 ? void 0 : _p$data.item;
  });
  const agentPolicyById = (0, _lodash.mapKeys)(agentPolicies, 'id');
  return {
    agentPoliciesLoading,
    agentPolicies,
    agentPolicyById
  };
};
exports.useAgentPolicies = useAgentPolicies;