"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentGroups = void 0;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _kibana = require("../common/lib/kibana");
var _use_agent_policies = require("./use_agent_policies");
var _search_strategy = require("../../common/search_strategy");
var _helpers = require("./helpers");
var _helpers2 = require("../common/helpers");
var _use_error_toast = require("../common/hooks/use_error_toast");
var _use_osquery_policies = require("./use_osquery_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentGroups = () => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  const {
    data: osqueryPolicies,
    isFetched: isOsqueryPoliciesFetched
  } = (0, _use_osquery_policies.useOsqueryPolicies)();
  const {
    agentPoliciesLoading,
    agentPolicyById
  } = (0, _use_agent_policies.useAgentPolicies)(osqueryPolicies);
  return (0, _reactQuery.useQuery)(['agentGroups'], async () => {
    const responseData = await (0, _rxjs.lastValueFrom)(data.search.search({
      filterQuery: {
        terms: {
          policy_id: osqueryPolicies
        }
      },
      factoryQueryType: _search_strategy.OsqueryQueries.agents,
      aggregations: {
        platforms: {
          terms: {
            field: 'local_metadata.os.platform'
          },
          aggs: {
            policies: {
              terms: {
                field: 'policy_id'
              }
            }
          }
        },
        policies: {
          terms: {
            field: 'policy_id'
          }
        }
      },
      pagination: (0, _helpers2.generateTablePaginationOptions)(0, 9000),
      sort: {
        direction: 'asc',
        field: 'local_metadata.os.platform'
      }
    }, {
      strategy: 'osquerySearchStrategy'
    }));
    return responseData;
  }, {
    select: response => {
      var _response$total;
      const {
        platforms,
        overlap,
        policies
      } = (0, _helpers.processAggregations)(response.rawResponse.aggregations);
      return {
        total: (_response$total = response.total) !== null && _response$total !== void 0 ? _response$total : 0,
        groups: {
          platforms,
          overlap,
          policies: policies.map(p => {
            var _agentPolicyById$p$id, _agentPolicyById$p$id2;
            const name = (_agentPolicyById$p$id = (_agentPolicyById$p$id2 = agentPolicyById[p.id]) === null || _agentPolicyById$p$id2 === void 0 ? void 0 : _agentPolicyById$p$id2.name) !== null && _agentPolicyById$p$id !== void 0 ? _agentPolicyById$p$id : p.name;
            return {
              ...p,
              name
            };
          })
        }
      };
    },
    placeholderData: {
      total: 0,
      edges: [],
      rawResponse: {
        took: 0,
        timed_out: false,
        _shards: {
          failed: 0,
          successful: 0,
          total: 0
        },
        hits: {
          hits: []
        }
      }
    },
    refetchOnWindowFocus: false,
    keepPreviousData: true,
    enabled: isOsqueryPoliciesFetched && !agentPoliciesLoading,
    onSuccess: () => setErrorToast(),
    onError: error => setErrorToast(error, {
      title: _i18n.i18n.translate('xpack.osquery.agent_groups.fetchError', {
        defaultMessage: 'Error while fetching agent groups'
      })
    })
  });
};
exports.useAgentGroups = useAgentGroups;