"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentsPolicyLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _kibana = require("../common/lib/kibana");
var _use_agent_policy = require("./use_agent_policy");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiLink = (0, _styledComponents.default)(_eui.EuiLink)`
  white-space: nowrap;
  text-overflow: ellipsis;
  overflow: hidden;
`;
const AgentsPolicyLinkComponent = ({
  policyId
}) => {
  var _data$name;
  const {
    application: {
      getUrlForApp,
      navigateToApp
    }
  } = (0, _kibana.useKibana)().services;
  const {
    data
  } = (0, _use_agent_policy.useAgentPolicy)({
    policyId
  });
  const href = (0, _react.useMemo)(() => getUrlForApp(_common.PLUGIN_ID, {
    path: _public.pagePathGetters.policy_details({
      policyId
    })[1]
  }), [getUrlForApp, policyId]);
  const handleClick = (0, _react.useCallback)(event => {
    if (!(0, _kibana.isModifiedEvent)(event) && (0, _kibana.isLeftClickEvent)(event)) {
      event.preventDefault();
      return navigateToApp(_common.PLUGIN_ID, {
        path: _public.pagePathGetters.policy_details({
          policyId
        })[1]
      });
    }
  }, [navigateToApp, policyId]);
  return /*#__PURE__*/_react.default.createElement(StyledEuiLink, {
    href: href,
    onClick: handleClick
  }, (_data$name = data === null || data === void 0 ? void 0 : data.name) !== null && _data$name !== void 0 ? _data$name : policyId);
};
const AgentsPolicyLink = /*#__PURE__*/_react.default.memo(AgentsPolicyLinkComponent);
exports.AgentsPolicyLink = AgentsPolicyLink;