"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActionResultsPrivileges = void 0;
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useActionResultsPrivileges = () => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)(['actionResultsPrivileges'], () => http.get('/internal/osquery/privileges_check'), {
    keepPreviousData: true
  });
};
exports.useActionResultsPrivileges = useActionResultsPrivileges;