"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentStatusBar = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _agent_status = require("./services/agent_status");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiColorPaletteDisplay = (0, _styledComponents.default)(_eui.EuiColorPaletteDisplay)`
  &.osquery-action-agent-status-bar {
    border: none;
    border-radius: 0;
    &:after {
      border: none;
    }
  }
`;
const AgentStatusBar = ({
  agentStatus
}) => {
  const palette = (0, _react.useMemo)(() => {
    let stop = 0;
    return _agent_status.AGENT_STATUSES.reduce((acc, status) => {
      stop += agentStatus[status] || 0;
      acc.push({
        stop,
        color: (0, _agent_status.getColorForAgentStatus)(status)
      });
      return acc;
    }, []);
  }, [agentStatus]);
  return /*#__PURE__*/_react.default.createElement(StyledEuiColorPaletteDisplay, {
    className: "osquery-action-agent-status-bar",
    size: "s",
    palette: palette
  });
};
exports.AgentStatusBar = AgentStatusBar;