"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilitySharedPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _navigation_registry = require("./components/page_template/helpers/navigation_registry");
var _page_template = require("./components/page_template");
var _update_global_navigation = require("./services/update_global_navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilitySharedPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "navigationRegistry", (0, _navigation_registry.createNavigationRegistry)());
  }
  setup() {
    return {
      navigation: {
        registerSections: this.navigationRegistry.registerSections
      }
    };
  }
  start(core, plugins) {
    const {
      application
    } = core;
    const PageTemplate = (0, _page_template.createLazyObservabilityPageTemplate)({
      currentAppId$: application.currentAppId$,
      getUrlForApp: application.getUrlForApp,
      navigateToApp: application.navigateToApp,
      navigationSections$: this.navigationRegistry.sections$,
      guidedOnboardingApi: plugins.guidedOnboarding.guidedOnboardingApi,
      getPageTemplateServices: () => ({
        coreStart: core
      })
    });
    return {
      navigation: {
        PageTemplate
      },
      updateGlobalNavigation: _update_global_navigation.updateGlobalNavigation
    };
  }
  stop() {}
}
exports.ObservabilitySharedPlugin = ObservabilitySharedPlugin;