"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteSLO = void 0;
var _constants = require("../../assets/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DeleteSLO {
  constructor(repository, transformManager, esClient, rulesClient) {
    this.repository = repository;
    this.transformManager = transformManager;
    this.esClient = esClient;
    this.rulesClient = rulesClient;
  }
  async execute(sloId) {
    const slo = await this.repository.findById(sloId);
    const sloTransformId = (0, _constants.getSLOTransformId)(slo.id, slo.revision);
    await this.transformManager.stop(sloTransformId);
    await this.transformManager.uninstall(sloTransformId);
    await this.deleteRollupData(slo.id);
    await this.deleteAssociatedRules(slo.id);
    await this.repository.deleteById(slo.id);
  }
  async deleteRollupData(sloId) {
    await this.esClient.deleteByQuery({
      index: `${_constants.SLO_INDEX_TEMPLATE_NAME}*`,
      wait_for_completion: false,
      query: {
        match: {
          'slo.id': sloId
        }
      }
    });
  }
  async deleteAssociatedRules(sloId) {
    try {
      await this.rulesClient.bulkDeleteRules({
        filter: `alert.attributes.params.sloId:${sloId}`
      });
    } catch (err) {
      // no-op: bulkDeleteRules throws if no rules are found.
    }
  }
}
exports.DeleteSLO = DeleteSLO;